# include "Types.h"
# include "yyTypes.w"
# include <stdio.h>
# if defined __STDC__ | defined __cplusplus
#  include <stdlib.h>
# else
   extern void exit ();
# endif
# include "Tree.h"
# include "Definiti.h"

# ifndef NULL
# define NULL 0L
# endif
# ifndef false
# define false 0
# endif
# ifndef true
# define true 1
# endif

# ifdef yyInline
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) \
  if ((ptr = (tree) free) >= (tree) max) ptr = alloc (); \
  free += nodesize [kind]; \
  ptr->yyHead.yyMark = 0; \
  ptr->Kind = kind;
# else
# define yyALLOC(tree, free, max, alloc, nodesize, make, ptr, kind) ptr = make (kind);
# endif

# define yyWrite(s) (void) fputs (s, yyf)
# define yyWriteNl (void) fputc ('\n', yyf)

# line 35 "Types.puma"

# include "Idents.h"
# include "StringMe.h"

# include "protocol.h"

# include "ShowDefs.h"   /* error message for definitions */


static FILE * yyf = stdout;

static void yyAbort
# ifdef __cplusplus
 (char * yyFunction)
# else
 (yyFunction) char * yyFunction;
# endif
{
 (void) fprintf (stderr, "Error: module Types, routine %s failed\n", yyFunction);
 exit (1);
}

int TreeListLength ARGS((tTree t));
int VarDistribution ARGS((tDefinitions v));
int TreeDistribution ARGS((tTree t));
static int DistributionMerge ARGS((int dist1, int dist2));
bool IsPureObj ARGS((tDefinitions v));
bool IsVarCommon ARGS((tDefinitions v));
bool IsVarDummy ARGS((tDefinitions v));
bool IsVarAllocatable ARGS((tDefinitions v));
static bool IsTreeAllocatable ARGS((tTree t));
bool IsVarOverlapped ARGS((tDefinitions v));
bool IsArrayOverlapped ARGS((tTree t));
bool IsIntrFunc ARGS((tTree t));
int VarRank ARGS((tDefinitions v));
int TreeRank ARGS((tTree t));
static int ParameterRank ARGS((tTree t));
int ParameterVars ARGS((tTree t));
tTree VarType ARGS((tDefinitions v));
tTree TreeType ARGS((tTree t));
int VarSize ARGS((tDefinitions v));
int TreeSize ARGS((tTree t));
static int IntrFuncRank ARGS((tIdent name, tTree param));
static int IntrFuncRedRank ARGS((tTree param));
bool IntrFuncKind1 ARGS((tIdent name));
bool IntrFuncKind2 ARGS((tIdent name));
bool IntrFuncKindn ARGS((tIdent name));
bool IntrFuncRed ARGS((tIdent name));
tTree ArrayCompType ARGS((tDefinitions v));
tTree ArrayFormals ARGS((tDefinitions v));
static bool IsConstExp ARGS((tTree t));
tIdent TreeVarName ARGS((tTree var));
tTree LastIndex ARGS((tTree t));

int TreeListLength
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 52 "Types.puma"
  {
# line 53 "Types.puma"
   if (! (t == NoTree)) goto yyL1;
  }
   return 0;
yyL1:;


  switch (t->Kind) {
  case kACF_LIST:
# line 57 "Types.puma"
   return 1 + TreeListLength (t->ACF_LIST.Next);

  case kACF_EMPTY:
# line 61 "Types.puma"
   return 0;

  case kBTE_LIST:
# line 65 "Types.puma"
   return (1 + TreeListLength (t->BTE_LIST.Next));

  case kBTE_EMPTY:
# line 69 "Types.puma"
   return 0;

  case kBTV_LIST:
# line 73 "Types.puma"
   return (1 + TreeListLength (t->BTV_LIST.Next));

  case kBTV_EMPTY:
# line 77 "Types.puma"
   return 0;

  case kBTP_LIST:
# line 81 "Types.puma"
   return (1 + TreeListLength (t->BTP_LIST.Next));

  case kBTP_EMPTY:
# line 85 "Types.puma"
   return 0;

  case kTYPE_LIST:
# line 89 "Types.puma"
   return (1 + TreeListLength (t->TYPE_LIST.Next));

  case kTYPE_EMPTY:
# line 93 "Types.puma"
   return 0;

  case kDECL_LIST:
# line 97 "Types.puma"
   return (1 + TreeListLength (t->DECL_LIST.Next));

  case kDECL_EMPTY:
# line 101 "Types.puma"
   return 0;

  case kDIST_LIST:
# line 105 "Types.puma"
   return (1 + TreeListLength (t->DIST_LIST.Next));

  case kDIST_EMPTY:
# line 109 "Types.puma"
   return 0;

  }

# line 113 "Types.puma"
  {
# line 114 "Types.puma"
   printf ("Illegal Tree in TreeListLength\n");
# line 115 "Types.puma"
   WriteTree (stdout, t);
  }
   return 0;

}

int VarDistribution
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
# line 133 "Types.puma"

char string[100];

# line 137 "Types.puma"
  {
# line 138 "Types.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 139 "Types.puma"
   printf ("Call of VarDistribution for NoObject\n");
# line 140 "Types.puma"
   kill_in_protocol ();
  }
  }
   return 0;
yyL1:;

  if (v->Kind == kVarObject) {
  if (v->VarObject.Dist->Kind == kHostDistribution) {
# line 144 "Types.puma"
   return - 1;

  }
  if (v->VarObject.Dist->Kind == kSerialDistribution) {
# line 148 "Types.puma"
   return 0;

  }
  if (v->VarObject.Dist->Kind == kNodeDistribution) {
# line 152 "Types.puma"
   return 1;

  }
  }
  if (v->Kind == kProcObject) {
# line 156 "Types.puma"
   return 0;

  }
  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
# line 160 "Types.puma"
   return 0;

  }
  if (v->FuncObject.decl->Kind == kSTMT_FUNC_DECL) {
# line 165 "Types.puma"
   return 0;

  }
  if (v->FuncObject.decl->Kind == kEXT_FUNC_DECL) {
# line 170 "Types.puma"
   return 0;

  }
  }
  if (v->Kind == kBlockObject) {
# line 175 "Types.puma"
  {
# line 176 "Types.puma"
   GetString (v->BlockObject.ident, string);
# line 177 "Types.puma"
   printf ("ERROR: VarDistribution for BlockObject %s\n", string);
# line 178 "Types.puma"
   FileUnparse (stdout, v->BlockObject.decl);
# line 179 "Types.puma"
   exit (- 1);
  }
   return 0;

  }
# line 183 "Types.puma"
  {
# line 184 "Types.puma"
 GetString (v->Object.ident, string);
# line 185 "Types.puma"
   printf ("Distribution not found for %s\n", string);
# line 186 "Types.puma"
   exit (- 1);
  }
   return 0;

}

int TreeDistribution
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 203 "Types.puma"

int r1, r2, r3;


  switch (t->Kind) {
  case kVAR_OBJ:
# line 207 "Types.puma"
   return VarDistribution (t->VAR_OBJ.Object);

  case kUSED_VAR:
# line 211 "Types.puma"
   return TreeDistribution (t->USED_VAR.VARNAME);

  case kLOOP_VAR:
# line 215 "Types.puma"
   return 0;

  case kINDEXED_VAR:
# line 219 "Types.puma"
  {
# line 220 "Types.puma"
   r1 = TreeDistribution (t->INDEXED_VAR.IND_VAR);
# line 221 "Types.puma"
   r2 = TreeDistribution (t->INDEXED_VAR.IND_EXPS);
  }
   return DistributionMerge (r1, r2);

  case kSUBSTRING_VAR:
# line 225 "Types.puma"
   return TreeDistribution (t->SUBSTRING_VAR.IND_VAR);

  case kDO_VAR:
# line 229 "Types.puma"
  {
# line 230 "Types.puma"
   r1 = TreeDistribution (t->DO_VAR.RANGE);
# line 231 "Types.puma"
   r2 = TreeDistribution (t->DO_VAR.BODY);
# line 232 "Types.puma"
   r1 = DistributionMerge (r1, r2);
  }
   return r1;

  case kBTV_LIST:
# line 236 "Types.puma"
  {
# line 237 "Types.puma"
   r1 = TreeDistribution (t->BTV_LIST.Elem);
# line 238 "Types.puma"
   r2 = TreeDistribution (t->BTV_LIST.Next);
  }
   return DistributionMerge (r1, r2);

  case kBTV_EMPTY:
# line 242 "Types.puma"
   return 0;

  case kBTE_LIST:
# line 246 "Types.puma"
  {
# line 247 "Types.puma"
   r1 = TreeDistribution (t->BTE_LIST.Elem);
# line 248 "Types.puma"
   r2 = TreeDistribution (t->BTE_LIST.Next);
  }
   return DistributionMerge (r1, r2);

  case kBTE_EMPTY:
# line 252 "Types.puma"
   return 0;

  case kARRAY_EXP:
# line 256 "Types.puma"
   return TreeDistribution (t->ARRAY_EXP.ELEMENTS);

  case kADDR:
# line 260 "Types.puma"
   return TreeDistribution (t->ADDR.E);

  case kDUMMY_EXP:
# line 264 "Types.puma"
   return 0;

  case kCONST_EXP:
# line 268 "Types.puma"
   return 0;

  case kSLICE_EXP:
# line 272 "Types.puma"
  {
# line 273 "Types.puma"
   r1 = TreeDistribution (t->SLICE_EXP.START);
# line 274 "Types.puma"
   r2 = TreeDistribution (t->SLICE_EXP.STOP);
# line 275 "Types.puma"
   r1 = DistributionMerge (r1, r2);
# line 276 "Types.puma"
   r3 = TreeDistribution (t->SLICE_EXP.INC);
# line 277 "Types.puma"
   r1 = DistributionMerge (r1, r2);
  }
   return r1;

  case kOP_EXP:
# line 281 "Types.puma"
  {
# line 282 "Types.puma"
   r1 = TreeDistribution (t->OP_EXP.OPND1);
# line 283 "Types.puma"
   r2 = TreeDistribution (t->OP_EXP.OPND2);
# line 284 "Types.puma"
   r1 = DistributionMerge (r1, r2);
  }
   return r1;

  case kOP1_EXP:
# line 288 "Types.puma"
   return TreeDistribution (t->OP1_EXP.OPND);

  case kVAR_EXP:
# line 292 "Types.puma"
   return TreeDistribution (t->VAR_EXP.V);

  case kFUNC_CALL_EXP:
# line 296 "Types.puma"
   return TreeDistribution (t->FUNC_CALL_EXP.FUNC_PARAMS);

  case kDO_EXP:
# line 300 "Types.puma"
  {
# line 301 "Types.puma"
   r1 = TreeDistribution (t->DO_EXP.RANGE);
# line 302 "Types.puma"
   r2 = TreeDistribution (t->DO_EXP.BODY);
# line 303 "Types.puma"
   r1 = DistributionMerge (r1, r2);
  }
   return r1;

  case kBTP_LIST:
# line 307 "Types.puma"
  {
# line 308 "Types.puma"
   r1 = TreeDistribution (t->BTP_LIST.Elem);
# line 309 "Types.puma"
   r2 = TreeDistribution (t->BTP_LIST.Next);
  }
   return DistributionMerge (r1, r2);

  case kBTP_EMPTY:
# line 313 "Types.puma"
   return 0;

  case kVAR_PARAM:
# line 317 "Types.puma"
   return TreeDistribution (t->VAR_PARAM.V);

  case kPROC_PARAM:
# line 321 "Types.puma"
   return 0;

  }

# line 325 "Types.puma"
  {
# line 326 "Types.puma"
   printf ("Determination of TreeDistribution (Types.puma) fails\n");
# line 327 "Types.puma"
   FileUnparse (stdout, t);
# line 328 "Types.puma"
   WriteTree (stdout, t);
  }
   return 0;

}

static int DistributionMerge
# if defined __STDC__ | defined __cplusplus
(register int dist1, register int dist2)
# else
(dist1, dist2)
 register int dist1;
 register int dist2;
# endif
{
  if (equalint (dist2, 0)) {
# line 334 "Types.puma"
   return dist1;

  }
  if (equalint (dist1, 0)) {
# line 338 "Types.puma"
   return dist2;

  }
# line 342 "Types.puma"
  {
# line 343 "Types.puma"
   if (! (dist1 == dist2)) goto yyL3;
  }
   return dist1;
yyL3:;

# line 347 "Types.puma"
   return - 2;

}

bool IsPureObj
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v == NoDefinitions) return false;
# line 359 "Types.puma"
  {
# line 360 "Types.puma"
   if (! ((v == NoObject))) goto yyL1;
  {
# line 361 "Types.puma"
   printf ("Call of IsPureObj for NoObject\n");
# line 362 "Types.puma"
   kill_in_protocol ();
# line 363 "Types.puma"
   return false;
  }
  }
yyL1:;

  if (v->Kind == kFuncObject) {
  if (v->FuncObject.decl->Kind == kFUNC_DECL) {
# line 366 "Types.puma"
  {
# line 368 "Types.puma"
   if (! ((v->FuncObject.decl->FUNC_DECL.IsPure != false))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  if (v->Kind == kProcObject) {
  if (v->ProcObject.decl->Kind == kPROC_DECL) {
# line 371 "Types.puma"
  {
# line 373 "Types.puma"
   if (! ((v->ProcObject.decl->PROC_DECL.IsPure != false))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  return false;
}

bool IsVarCommon
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v == NoDefinitions) return false;
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarCommon) {
# line 384 "Types.puma"
   return true;

  }
  }
  return false;
}

bool IsVarDummy
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v == NoDefinitions) return false;
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 389 "Types.puma"
   return true;

  }
  }
  return false;
}

bool IsVarAllocatable
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v == NoDefinitions) return false;
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
  if (v->VarObject.Kind->Kind == kVarLocal) {
# line 400 "Types.puma"
  {
# line 401 "Types.puma"
   if (! (IsTreeAllocatable (v->VarObject.decl->VAR_DECL.VAL))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (v->VarObject.Kind->Kind == kVarCommon) {
# line 408 "Types.puma"
  {
# line 409 "Types.puma"
   if (! (IsTreeAllocatable (v->VarObject.decl->VAR_DECL.VAL))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 404 "Types.puma"
  {
# line 405 "Types.puma"
   if (! (IsTreeAllocatable (v->VarObject.decl->VAR_PARAM_DECL.VAL))) goto yyL2;
  }
   return true;
yyL2:;

  }
  }
  }
  return false;
}

static bool IsTreeAllocatable
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return false;
  if (t->Kind == kARRAY_TYPE) {
# line 414 "Types.puma"
  {
# line 415 "Types.puma"
   if (! (IsTreeAllocatable (t->ARRAY_TYPE.ARRAY_INDEX_TYPES))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kTYPE_LIST) {
# line 418 "Types.puma"
  {
# line 419 "Types.puma"
   if (! (IsTreeAllocatable (t->TYPE_LIST.Elem))) goto yyL2;
  {
# line 420 "Types.puma"
   if (! (IsTreeAllocatable (t->TYPE_LIST.Next))) goto yyL2;
  }
  }
   return true;
yyL2:;

  }
  if (t->Kind == kTYPE_EMPTY) {
# line 423 "Types.puma"
   return true;

  }
  if (t->Kind == kDYNAMIC) {
# line 426 "Types.puma"
   return true;

  }
  return false;
}

bool IsVarOverlapped
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v == NoDefinitions) return false;
  if (v->Kind == kVarObject) {
  if (v->VarObject.Kind->Kind == kVarLocal) {
# line 437 "Types.puma"
  {
# line 438 "Types.puma"
   if (! (IsArrayOverlapped (v->VarObject.decl))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (v->VarObject.Kind->Kind == kVarDummy) {
# line 441 "Types.puma"
  {
# line 442 "Types.puma"
   if (! (IsArrayOverlapped (v->VarObject.decl))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (v->VarObject.Kind->Kind == kVarCommon) {
# line 445 "Types.puma"
  {
# line 446 "Types.puma"
   if (! (IsArrayOverlapped (v->VarObject.decl))) goto yyL3;
  }
   return true;
yyL3:;

  }
  }
  return false;
}

bool IsArrayOverlapped
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return false;

  switch (t->Kind) {
  case kVAR_OBJ:
# line 451 "Types.puma"
  {
# line 452 "Types.puma"
   if (! (IsVarOverlapped (t->VAR_OBJ.Object))) goto yyL1;
  }
   return true;
yyL1:;

  break;
  case kUSED_VAR:
# line 455 "Types.puma"
  {
# line 456 "Types.puma"
   if (! (IsArrayOverlapped (t->USED_VAR.VARNAME))) goto yyL2;
  }
   return true;
yyL2:;

  break;
  case kINDEXED_VAR:
# line 459 "Types.puma"
  {
# line 460 "Types.puma"
   if (! (IsArrayOverlapped (t->INDEXED_VAR.IND_VAR))) goto yyL3;
  }
   return true;
yyL3:;

  break;
  case kVAR_DECL:
# line 463 "Types.puma"
  {
# line 464 "Types.puma"
   if (! (IsArrayOverlapped (t->VAR_DECL.VAL))) goto yyL4;
  }
   return true;
yyL4:;

  break;
  case kVAR_PARAM_DECL:
# line 467 "Types.puma"
  {
# line 468 "Types.puma"
   if (! (IsArrayOverlapped (t->VAR_PARAM_DECL.VAL))) goto yyL5;
  }
   return true;
yyL5:;

  break;
  case kARRAY_TYPE:
# line 471 "Types.puma"
  {
# line 472 "Types.puma"
   if (! (IsArrayOverlapped (t->ARRAY_TYPE.ARRAY_INDEX_TYPES))) goto yyL6;
  }
   return true;
yyL6:;

  break;
  case kTYPE_LIST:
# line 475 "Types.puma"
  {
# line 476 "Types.puma"
   if (! (IsArrayOverlapped (t->TYPE_LIST.Elem))) goto yyL7;
  }
   return true;
yyL7:;

# line 479 "Types.puma"
  {
# line 480 "Types.puma"
   if (! (IsArrayOverlapped (t->TYPE_LIST.Next))) goto yyL8;
  }
   return true;
yyL8:;

  break;
  case kDYNAMIC:
# line 483 "Types.puma"
  {
# line 484 "Types.puma"
   if (! (((t->DYNAMIC.left_overlap > 0) || (t->DYNAMIC.right_overlap > 0)))) goto yyL9;
  }
   return true;
yyL9:;

  break;
  case kINDEX_TYPE:
# line 487 "Types.puma"
  {
# line 488 "Types.puma"
   if (! (((t->INDEX_TYPE.left_overlap > 0) || (t->INDEX_TYPE.right_overlap > 0)))) goto yyL10;
  }
   return true;
yyL10:;

  break;
  }

  return false;
}

bool IsIntrFunc
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 499 "Types.puma"

tObject hobj;

  if (t == NoTree) return false;
  if (t->Kind == kFUNC_CALL_EXP) {
# line 503 "Types.puma"
  {
# line 504 "Types.puma"
   if (! (IsIntrFunc (t->FUNC_CALL_EXP.FUNC_ID))) goto yyL1;
  }
   return true;
yyL1:;

  }
  if (t->Kind == kPROC_OBJ) {
# line 507 "Types.puma"
 {
  tDefinitions hobj;
  {
# line 509 "Types.puma"

# line 511 "Types.puma"
   hobj = GetDeclEntry (t->PROC_OBJ.Ident, GetIntrinsicEntries ());
# line 513 "Types.puma"
   if (! (hobj != NoObject)) goto yyL2;
  {
# line 514 "Types.puma"
   if (! (hobj == t->PROC_OBJ.Object)) goto yyL2;
  }
  }
   return true;
 }
yyL2:;

  }
  return false;
}

int VarRank
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
# line 525 "Types.puma"
   return TreeRank (v->VarObject.decl->VAR_DECL.VAL);

  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 529 "Types.puma"
   return TreeRank (v->VarObject.decl->VAR_PARAM_DECL.VAL);

  }
  if (v->VarObject.decl->Kind == kPARAMETER_DECL) {
# line 533 "Types.puma"
   return 0;

  }
# line 541 "Types.puma"
  {
# line 542 "Types.puma"
   printf ("Unknown VarObject for VarRank\n");
# line 543 "Types.puma"
   FileUnparse (stdout, v->VarObject.decl);
  }
   return 0;

  }
  if (v->Kind == kTemplateObject) {
  if (v->TemplateObject.decl->Kind == kTEMPLATE_DECL) {
# line 537 "Types.puma"
   return TreeRank (v->TemplateObject.decl->TEMPLATE_DECL.DIMENSIONS);

  }
  }
  if (v->Kind == kFuncObject) {
# line 547 "Types.puma"
   return 0;

  }
# line 553 "Types.puma"
  {
# line 555 "Types.puma"
   printf ("VarRank (module Types) failed\n");
# line 556 "Types.puma"
   SemFile = stdout;
# line 557 "Types.puma"
   ShowDeclarations (v);
# line 558 "Types.puma"
   exit (- 1);
  }
   return 0;

}

int TreeRank
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 571 "Types.puma"

int r1, r2, r3;
tTree list;
char string [100];


  switch (t->Kind) {
  case kVAR_DECL:
# line 577 "Types.puma"
   return TreeRank (t->VAR_DECL.VAL);

  case kVAR_PARAM_DECL:
# line 581 "Types.puma"
   return TreeRank (t->VAR_PARAM_DECL.VAL);

  case kPARAMETER_DECL:
# line 585 "Types.puma"
   return 0;

  case kDUMMY_TYPE:
# line 589 "Types.puma"
   return 0;

  case kINTEGER_TYPE:
# line 593 "Types.puma"
   return 0;

  case kREAL_TYPE:
# line 597 "Types.puma"
   return 0;

  case kBOOLEAN_TYPE:
# line 601 "Types.puma"
   return 0;

  case kCOMPLEX_TYPE:
# line 605 "Types.puma"
   return 0;

  case kSTRING_TYPE:
# line 609 "Types.puma"
   return 0;

  case kARRAY_TYPE:
# line 614 "Types.puma"
   return TreeListLength (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);

  case kTYPE_LIST:
# line 620 "Types.puma"
   return TreeListLength (t);

  case kTYPE_EMPTY:
# line 624 "Types.puma"
   return 0;

  case kTYPE_ID:
# line 628 "Types.puma"
   return 0;

  case kVAR_OBJ:
# line 632 "Types.puma"
   return VarRank (t->VAR_OBJ.Object);

  case kUSED_VAR:
# line 636 "Types.puma"
   return TreeRank (t->USED_VAR.VARNAME);

  case kSUBSTRING_VAR:
# line 640 "Types.puma"
   return TreeRank (t->SUBSTRING_VAR.IND_VAR);

  case kLOOP_VAR:
# line 644 "Types.puma"
   return 0;

  case kINDEXED_VAR:
# line 648 "Types.puma"
  {
# line 649 "Types.puma"
 r1 = TreeRank (t->INDEXED_VAR.IND_VAR);
      r2 = TreeListLength (t->INDEXED_VAR.IND_EXPS);
      if (r2 != r1)
         { printf ("Illegal indirect addressing\n");
           printf ("Rank of var = %d, no. of indexes = %d\n", r1, r2);
           FileUnparse (stdout, t);
           printf ("\n");
         }
      list = t->INDEXED_VAR.IND_EXPS;
      r2 = 0;
      while (list->Kind == kBTE_LIST)
         { r2 += TreeRank (list->BTE_LIST.Elem);
           list = list->BTE_LIST.Next;
         }

  }
   return r2;

  case kSELECTED_VAR:
# line 668 "Types.puma"
   return TreeRank (t->SELECTED_VAR.SELEC_VAR) + VarRank (t->SELECTED_VAR.SELECTOR->REC_COMP.Object);

  case kDO_VAR:
# line 672 "Types.puma"
   return 1;

  case kADDR:
# line 677 "Types.puma"
   return TreeRank (t->ADDR.E);

  case kDUMMY_EXP:
# line 681 "Types.puma"
   return 0;

  case kCONST_EXP:
# line 685 "Types.puma"
   return 0;

  case kARRAY_EXP:
# line 689 "Types.puma"
   return 1;

  case kSLICE_EXP:
# line 694 "Types.puma"
  {
# line 695 "Types.puma"
 r1 = TreeRank (t->SLICE_EXP.START);
      r2 = TreeRank (t->SLICE_EXP.STOP);
      r3 = TreeRank (t->SLICE_EXP.INC);
      if ( (r1 != 0) || (r2 != 0) || (r3 != 0) )
        { printf ("Illegal Rank in a slice expression\n");
          FileUnparse (stdout, t);
        }

  }
   return 1;

  case kOP_EXP:
# line 706 "Types.puma"
  {
# line 707 "Types.puma"
 r1 = TreeRank (t->OP_EXP.OPND1);
       r2 = TreeRank (t->OP_EXP.OPND2);
       if (r1 == 0)
          r1 = r2;
       else if (r2 == 0)
          r1 = r1;
       else if (r1 != r2)
          { printf ("Rank Error for binary expression\n");
            FileUnparse (stdout, t);
          }

  }
   return r1;

  case kOP1_EXP:
# line 721 "Types.puma"
   return TreeRank (t->OP1_EXP.OPND);

  case kVAR_EXP:
# line 725 "Types.puma"
   return TreeRank (t->VAR_EXP.V);

  case kFUNC_CALL_EXP:
# line 729 "Types.puma"
  {
# line 730 "Types.puma"
 if (IsIntrFunc (t))
         {
           if (IntrFuncKind1 (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
             { r1 = TreeListLength (t->FUNC_CALL_EXP.FUNC_PARAMS);
               if (r1 == 1)
                 r1 = TreeRank (t->FUNC_CALL_EXP.FUNC_PARAMS->BTP_LIST.Elem);
                else
                 printf ("Illegal ParamList for Intrinsic1\n");
             }
           else if (IntrFuncKind2 (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
             { r1 = ParameterRank (t->FUNC_CALL_EXP.FUNC_PARAMS); }
           else if (IntrFuncKindn (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident))
             { r1 = ParameterRank (t->FUNC_CALL_EXP.FUNC_PARAMS); }
           else
             { r1 = IntrFuncRank (t->FUNC_CALL_EXP.FUNC_ID->PROC_OBJ.Ident, t->FUNC_CALL_EXP.FUNC_PARAMS);
               if (r1 < 0)
                { printf ("Don't know rank of intrinsic function\n");
                  FileUnparse (stdout, t);
                }
             }
         }
        else
         {
           r1 = 0;
         }

  }
   return r1;

  case kDO_EXP:
# line 759 "Types.puma"
   return 1;

  case kVAR_PARAM:
# line 764 "Types.puma"
   return TreeRank (t->VAR_PARAM.V);

  }

# line 768 "Types.puma"
  {
# line 769 "Types.puma"
   printf ("Tree Rank failed\n");
# line 770 "Types.puma"
   FileUnparse (stdout, t);
# line 771 "Types.puma"
   WriteTree (stdout, t);
  }
   return 0;

}

static int ParameterRank
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 783 "Types.puma"
 int h, h1, h2;
  if (t->Kind == kBTP_EMPTY) {
# line 793 "Types.puma"
   return 0;

  }
  if (t->Kind == kBTP_LIST) {
# line 797 "Types.puma"
  {
# line 798 "Types.puma"
 h2 = ParameterRank (t->BTP_LIST.Next);
      h1 = TreeRank (t->BTP_LIST.Elem);
      if (h1 != 0)
        { if ((h2 == 0) || (h1 == h2))
            h = h1;
           else
            h = -1;
        }
       else
         h = h2;

  }
   return h;

  }
 yyAbort ("ParameterRank");
}

int ParameterVars
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 820 "Types.puma"

int n;
char string [100];


  switch (t->Kind) {
  case kARRAY_TYPE:
# line 831 "Types.puma"
   return ParameterVars (t->ARRAY_TYPE.ARRAY_INDEX_TYPES);

  case kTYPE_LIST:
# line 835 "Types.puma"
   return ParameterVars (t->TYPE_LIST.Elem) + ParameterVars (t->TYPE_LIST.Next);

  case kTYPE_EMPTY:
# line 839 "Types.puma"
   return 0;

  case kINDEX_TYPE:
# line 843 "Types.puma"
   return ParameterVars (t->INDEX_TYPE.LOWER) + ParameterVars (t->INDEX_TYPE.UPPER);

  case kDYNAMIC:
# line 847 "Types.puma"
   return 0;

  case kVAR_OBJ:
  if (t->VAR_OBJ.Object->Kind == kVarObject) {
  if (t->VAR_OBJ.Object->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 857 "Types.puma"
   return 1;

  }
  }
# line 861 "Types.puma"
   return 0;

  case kUSED_VAR:
# line 866 "Types.puma"
   return ParameterVars (t->USED_VAR.VARNAME);

  case kLOOP_VAR:
# line 870 "Types.puma"
   return 0;

  case kINDEXED_VAR:
# line 874 "Types.puma"
   return ParameterVars (t->INDEXED_VAR.IND_VAR) + ParameterVars (t->INDEXED_VAR.IND_EXPS);

  case kADDR:
# line 878 "Types.puma"
   return ParameterVars (t->ADDR.E);

  case kDUMMY_EXP:
# line 882 "Types.puma"
   return 0;

  case kCONST_EXP:
# line 886 "Types.puma"
   return 0;

  case kARRAY_EXP:
# line 890 "Types.puma"
   return ParameterVars (t->ARRAY_EXP.ELEMENTS);

  case kSLICE_EXP:
# line 894 "Types.puma"
   return ParameterVars (t->SLICE_EXP.START) + ParameterVars (t->SLICE_EXP.STOP) + ParameterVars (t->SLICE_EXP.INC);

  case kOP_EXP:
# line 899 "Types.puma"
   return ParameterVars (t->OP_EXP.OPND1) + ParameterVars (t->OP_EXP.OPND2);

  case kOP1_EXP:
# line 903 "Types.puma"
   return ParameterVars (t->OP1_EXP.OPND);

  case kVAR_EXP:
# line 907 "Types.puma"
   return ParameterVars (t->VAR_EXP.V);

  case kFUNC_CALL_EXP:
# line 911 "Types.puma"
   return ParameterVars (t->FUNC_CALL_EXP.FUNC_PARAMS);

  case kDO_EXP:
# line 915 "Types.puma"
   return ParameterVars (t->DO_EXP.RANGE) + ParameterVars (t->DO_EXP.BODY);

  case kBTE_LIST:
# line 919 "Types.puma"
   return ParameterVars (t->BTE_LIST.Elem) + ParameterVars (t->BTE_LIST.Next);

  case kBTE_EMPTY:
# line 923 "Types.puma"
   return 0;

  case kBTP_LIST:
# line 927 "Types.puma"
   return ParameterVars (t->BTP_LIST.Elem) + ParameterVars (t->BTP_LIST.Next);

  case kBTP_EMPTY:
# line 931 "Types.puma"
   return 0;

  case kVAR_PARAM:
# line 935 "Types.puma"
   return ParameterVars (t->VAR_PARAM.V);

  }

# line 939 "Types.puma"
  {
# line 940 "Types.puma"
   printf ("Parameter Vars failed\n");
# line 941 "Types.puma"
   FileUnparse (stdout, t);
# line 942 "Types.puma"
   WriteTree (stdout, t);
  }
   return 0;

}

tTree VarType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
# line 954 "Types.puma"
   return TreeType (v->VarObject.decl->VAR_DECL.VAL);

  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 958 "Types.puma"
   return TreeType (v->VarObject.decl->VAR_PARAM_DECL.VAL);

  }
# line 962 "Types.puma"
  {
# line 963 "Types.puma"
   printf ("Unknown VarObject for VarType (no array !)\n");
# line 964 "Types.puma"
   FileUnparse (stdout, v->VarObject.decl);
  }
   return NoTree;

  }
 yyAbort ("VarType");
}

tTree TreeType
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 980 "Types.puma"

int r1, r2, r3;
tTree list;
tObject hobj;
char string[100];


  switch (t->Kind) {
  case kDUMMY_TYPE:
# line 987 "Types.puma"
   return t;

  case kINTEGER_TYPE:
# line 991 "Types.puma"
   return t;

  case kREAL_TYPE:
# line 995 "Types.puma"
   return t;

  case kBOOLEAN_TYPE:
# line 999 "Types.puma"
   return t;

  case kCOMPLEX_TYPE:
# line 1003 "Types.puma"
   return t;

  case kSTRING_TYPE:
# line 1007 "Types.puma"
   return t;

  case kTYPE_ID:
# line 1011 "Types.puma"
   return t;

  case kARRAY_TYPE:
# line 1015 "Types.puma"
   return TreeType (t->ARRAY_TYPE.ARRAY_COMP_TYPE);

  case kVAR_OBJ:
# line 1020 "Types.puma"
   return VarType (t->VAR_OBJ.Object);

  case kUSED_VAR:
# line 1024 "Types.puma"
   return TreeType (t->USED_VAR.VARNAME);

  case kLOOP_VAR:
# line 1028 "Types.puma"
   return TreeType (t->LOOP_VAR.LOOP_VARNAME);

  case kINDEXED_VAR:
# line 1032 "Types.puma"
   return TreeType (t->INDEXED_VAR.IND_VAR);

  }

# line 1036 "Types.puma"
  {
# line 1037 "Types.puma"
   printf ("Tree Type failed\n");
# line 1038 "Types.puma"
   FileUnparse (stdout, t);
# line 1039 "Types.puma"
   WriteTree (stdout, t);
  }
   return NoTree;

}

int VarSize
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
# line 1051 "Types.puma"
   return TreeSize (v->VarObject.decl->VAR_DECL.VAL);

  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
# line 1055 "Types.puma"
   return TreeSize (v->VarObject.decl->VAR_PARAM_DECL.VAL);

  }
# line 1059 "Types.puma"
  {
# line 1060 "Types.puma"
   printf ("Unknown VarObject for VarSize\n");
# line 1061 "Types.puma"
   FileUnparse (stdout, v->VarObject.decl);
  }
   return 0;

  }
 yyAbort ("VarSize");
}

int TreeSize
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
# line 1073 "Types.puma"

int r1, r2, r3;
bool found;
tTree list;
tObject hobj;
char string[100];


  switch (t->Kind) {
  case kINTEGER_TYPE:
# line 1081 "Types.puma"
   return (t->INTEGER_TYPE.size);

  case kREAL_TYPE:
# line 1085 "Types.puma"
   return (t->REAL_TYPE.size);

  case kBOOLEAN_TYPE:
# line 1089 "Types.puma"
   return (t->BOOLEAN_TYPE.size);

  case kCOMPLEX_TYPE:
# line 1093 "Types.puma"
   return (t->COMPLEX_TYPE.size);

  case kSTRING_TYPE:
# line 1097 "Types.puma"
  {
# line 1098 "Types.puma"
 GetIntConstValue (t->STRING_TYPE.LENGTH, &found, &r1);
      if (!found)
        { r1 = 0;
          printf ("Tree Size failed for STRING-TYPE\n");
          FileUnparse (stdout, t);
        }

  }
   return r1;

  case kARRAY_TYPE:
# line 1108 "Types.puma"
   return TreeSize (t->ARRAY_TYPE.ARRAY_COMP_TYPE);

  case kVAR_OBJ:
# line 1112 "Types.puma"
   return VarSize (t->VAR_OBJ.Object);

  case kUSED_VAR:
# line 1116 "Types.puma"
   return TreeSize (t->USED_VAR.VARNAME);

  case kLOOP_VAR:
# line 1120 "Types.puma"
   return TreeSize (t->LOOP_VAR.LOOP_VARNAME);

  case kINDEXED_VAR:
# line 1124 "Types.puma"
   return TreeSize (t->INDEXED_VAR.IND_VAR);

  }

# line 1128 "Types.puma"
  {
# line 1129 "Types.puma"
   printf ("Tree Size failed\n");
# line 1130 "Types.puma"
   FileUnparse (stdout, t);
# line 1131 "Types.puma"
   WriteTree (stdout, t);
  }
   return 0;

}

static int IntrFuncRank
# if defined __STDC__ | defined __cplusplus
(register tIdent name, register tTree param)
# else
(name, param)
 register tIdent name;
 register tTree param;
# endif
{
# line 1146 "Types.puma"
  {
# line 1147 "Types.puma"
   if (! (IntrFuncRed (name) == true)) goto yyL1;
  }
   return IntrFuncRedRank (param);
yyL1:;

  if (equaltIdent (name, MakeIdent ("TRANSPOSE", 9))) {
  if (param->Kind == kBTP_LIST) {
# line 1151 "Types.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, MakeIdent ("CSHIFT", 6))) {
  if (param->Kind == kBTP_LIST) {
# line 1155 "Types.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  if (equaltIdent (name, MakeIdent ("SPREAD", 6))) {
  if (param->Kind == kBTP_LIST) {
# line 1159 "Types.puma"
   return (TreeRank (param->BTP_LIST.Elem) + 1);

  }
  }
  if (equaltIdent (name, MakeIdent ("MERGE", 5))) {
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1164 "Types.puma"
   return TreeRank (param->BTP_LIST.Elem);

  }
  }
  }
  }
  }
# line 1172 "Types.puma"
   return - 1;

}

static int IntrFuncRedRank
# if defined __STDC__ | defined __cplusplus
(register tTree param)
# else
(param)
 register tTree param;
# endif
{
  if (param->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1186 "Types.puma"
   return 0;

  }
  if (param->BTP_LIST.Next->Kind == kBTP_LIST) {
  if (param->BTP_LIST.Next->BTP_LIST.Next->Kind == kBTP_EMPTY) {
# line 1190 "Types.puma"
   return (TreeRank (param->BTP_LIST.Elem) - 1);

  }
  }
  }
# line 1195 "Types.puma"
   return - 1;

}

bool IntrFuncKind1
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, MakeIdent ("ABS", 3))) {
# line 1201 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IABS", 4))) {
# line 1202 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DABS", 4))) {
# line 1203 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CABS", 4))) {
# line 1204 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CDABS", 5))) {
# line 1205 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("AIMAG", 5))) {
# line 1207 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DIMAG", 5))) {
# line 1208 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ATAN", 4))) {
# line 1210 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DATAN", 5))) {
# line 1211 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CONJG", 5))) {
# line 1213 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("COS", 3))) {
# line 1215 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CCOS", 4))) {
# line 1216 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DCOS", 4))) {
# line 1217 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CDCOS", 5))) {
# line 1218 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ACOS", 4))) {
# line 1219 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DACOS", 5))) {
# line 1220 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("COSH", 4))) {
# line 1222 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DCOSH", 5))) {
# line 1223 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("EXP", 3))) {
# line 1225 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DEXP", 4))) {
# line 1226 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DBLE", 4))) {
# line 1228 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("FLOAT", 5))) {
# line 1229 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DFLOAT", 6))) {
# line 1230 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IFIX", 4))) {
# line 1231 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ICHAR", 5))) {
# line 1233 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CHAR", 4))) {
# line 1234 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("INT", 3))) {
# line 1236 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("NINT", 4))) {
# line 1237 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IDINT", 5))) {
# line 1238 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("LOG", 3))) {
# line 1240 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ALOG", 4))) {
# line 1241 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CLOG", 4))) {
# line 1242 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DLOG", 4))) {
# line 1243 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CDLOG", 5))) {
# line 1244 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("LOG10", 5))) {
# line 1246 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ALOG10", 6))) {
# line 1247 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DLOG10", 6))) {
# line 1248 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ODD", 3))) {
# line 1250 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("REAL", 4))) {
# line 1252 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DREAL", 5))) {
# line 1253 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ROUND", 5))) {
# line 1255 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("SIN", 3))) {
# line 1257 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DSIN", 4))) {
# line 1258 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CSIN", 4))) {
# line 1259 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CDSIN", 5))) {
# line 1260 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ASIN", 4))) {
# line 1261 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DASIN", 5))) {
# line 1262 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("SINH", 4))) {
# line 1264 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DSINH", 5))) {
# line 1265 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("SQR", 3))) {
# line 1267 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("SQRT", 4))) {
# line 1268 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DSQRT", 5))) {
# line 1269 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("TAN", 3))) {
# line 1271 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DTAN", 4))) {
# line 1272 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("TRUNC", 5))) {
# line 1274 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("NOT", 3))) {
# line 1276 "Types.puma"
   return true;

  }
  return false;
}

bool IntrFuncKind2
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, MakeIdent ("SIGN", 4))) {
# line 1282 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ISIGN", 5))) {
# line 1283 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DSIGN", 5))) {
# line 1284 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("MOD", 3))) {
# line 1286 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DMOD", 4))) {
# line 1287 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("AMOD", 4))) {
# line 1288 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("CMPLX", 5))) {
# line 1289 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DCMPLX", 6))) {
# line 1290 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("LGT", 3))) {
# line 1292 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("LGE", 3))) {
# line 1293 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("LLT", 3))) {
# line 1294 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("LLE", 3))) {
# line 1295 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ATAN2", 5))) {
# line 1297 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DATAN2", 6))) {
# line 1298 "Types.puma"
   return true;

  }
  return false;
}

bool IntrFuncKindn
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, MakeIdent ("MIN", 3))) {
# line 1302 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("MIN0", 4))) {
# line 1303 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("AMIN1", 5))) {
# line 1304 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DMIN1", 5))) {
# line 1305 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("MAX", 3))) {
# line 1307 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("MAX0", 4))) {
# line 1308 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("AMAX1", 5))) {
# line 1309 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("DMAX1", 5))) {
# line 1310 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IBSET", 5))) {
# line 1312 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IBCLR", 5))) {
# line 1313 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IAND", 4))) {
# line 1314 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IOR", 3))) {
# line 1315 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IEOR", 4))) {
# line 1316 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ISHFT", 5))) {
# line 1317 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ISHFTC", 6))) {
# line 1318 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("BTEST", 5))) {
# line 1320 "Types.puma"
   return true;

  }
  return false;
}

bool IntrFuncRed
# if defined __STDC__ | defined __cplusplus
(register tIdent name)
# else
(name)
 register tIdent name;
# endif
{
  if (equaltIdent (name, MakeIdent ("MINVAL", 6))) {
# line 1326 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("MAXVAL", 6))) {
# line 1327 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("SUM", 3))) {
# line 1328 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("PRODUCT", 7))) {
# line 1329 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("COUNT", 5))) {
# line 1330 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ANY", 3))) {
# line 1331 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("ALL", 3))) {
# line 1332 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IALL", 4))) {
# line 1334 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IANY", 4))) {
# line 1335 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("IPARITY", 7))) {
# line 1336 "Types.puma"
   return true;

  }
  if (equaltIdent (name, MakeIdent ("PARITY", 6))) {
# line 1337 "Types.puma"
   return true;

  }
  return false;
}

tTree ArrayCompType
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
  if (v->VarObject.decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1347 "Types.puma"
   return v->VarObject.decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE;

  }
  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (v->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1351 "Types.puma"
   return v->VarObject.decl->VAR_PARAM_DECL.VAL->ARRAY_TYPE.ARRAY_COMP_TYPE;

  }
  }
# line 1355 "Types.puma"
  {
# line 1356 "Types.puma"
   printf ("Unknown VarObject for ArrayCompType\n");
# line 1357 "Types.puma"
   WriteTree (stdout, v->VarObject.decl);
# line 1358 "Types.puma"
   kill_in_protocol ();
  }
   return NoTree;

  }
 yyAbort ("ArrayCompType");
}

tTree ArrayFormals
# if defined __STDC__ | defined __cplusplus
(register tDefinitions v)
# else
(v)
 register tDefinitions v;
# endif
{
  if (v->Kind == kVarObject) {
  if (v->VarObject.decl->Kind == kVAR_DECL) {
  if (v->VarObject.decl->VAR_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1370 "Types.puma"
   return v->VarObject.decl->VAR_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES;

  }
  }
  if (v->VarObject.decl->Kind == kVAR_PARAM_DECL) {
  if (v->VarObject.decl->VAR_PARAM_DECL.VAL->Kind == kARRAY_TYPE) {
# line 1374 "Types.puma"
   return v->VarObject.decl->VAR_PARAM_DECL.VAL->ARRAY_TYPE.ARRAY_INDEX_TYPES;

  }
  }
  }
# line 1378 "Types.puma"
  {
# line 1379 "Types.puma"
   printf ("Illegal Object for ArrayFormals\n");
# line 1380 "Types.puma"
   obj_error_protocol ("illegal object for ArrayFormals", v);
# line 1381 "Types.puma"
   kill_in_protocol ();
  }
   return NoTree;

}

static bool IsConstExp
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t == NoTree) return false;
  if (t->Kind == kCONST_EXP) {
# line 1393 "Types.puma"
   return true;

  }
  if (t->Kind == kARRAY_EXP) {
# line 1395 "Types.puma"
  {
# line 1396 "Types.puma"
   if (! (IsConstExp (t->ARRAY_EXP.ELEMENTS))) goto yyL2;
  }
   return true;
yyL2:;

  }
  if (t->Kind == kSLICE_EXP) {
# line 1399 "Types.puma"
  {
# line 1400 "Types.puma"
   if (! (IsConstExp (t->SLICE_EXP.START))) goto yyL3;
  {
# line 1401 "Types.puma"
   if (! (IsConstExp (t->SLICE_EXP.STOP))) goto yyL3;
  {
# line 1402 "Types.puma"
   if (! (IsConstExp (t->SLICE_EXP.INC))) goto yyL3;
  }
  }
  }
   return true;
yyL3:;

  }
  if (t->Kind == kOP_EXP) {
# line 1405 "Types.puma"
  {
# line 1406 "Types.puma"
   if (! (IsConstExp (t->OP_EXP.OPND1))) goto yyL4;
  {
# line 1407 "Types.puma"
   if (! (IsConstExp (t->OP_EXP.OPND2))) goto yyL4;
  }
  }
   return true;
yyL4:;

  }
  if (t->Kind == kOP1_EXP) {
# line 1410 "Types.puma"
  {
# line 1411 "Types.puma"
   if (! (IsConstExp (t->OP1_EXP.OPND))) goto yyL5;
  }
   return true;
yyL5:;

  }
  if (t->Kind == kVAR_EXP) {
  if (t->VAR_EXP.V->Kind == kUSED_VAR) {
  if (t->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object->Kind == kVarObject) {
  if (t->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Kind->Kind == kVarConstant) {
# line 1414 "Types.puma"
  {
# line 1416 "Types.puma"
   if (! (IsConstExp (t->VAR_EXP.V->USED_VAR.VARNAME->VAR_OBJ.Object->VarObject.Kind->VarConstant.Val))) goto yyL6;
  }
   return true;
yyL6:;

  }
  }
  }
  }
  return false;
}

tIdent TreeVarName
# if defined __STDC__ | defined __cplusplus
(register tTree var)
# else
(var)
 register tTree var;
# endif
{
  if (var->Kind == kVAR_OBJ) {
# line 1427 "Types.puma"
   return var->VAR_OBJ.Ident;

  }
  if (var->Kind == kUSED_VAR) {
# line 1431 "Types.puma"
   return TreeVarName (var->USED_VAR.VARNAME);

  }
  if (var->Kind == kLOOP_VAR) {
# line 1435 "Types.puma"
   return TreeVarName (var->LOOP_VAR.LOOP_VARNAME);

  }
  if (var->Kind == kVAR_EXP) {
# line 1439 "Types.puma"
   return TreeVarName (var->VAR_EXP.V);

  }
  if (var->Kind == kINDEXED_VAR) {
# line 1443 "Types.puma"
   return TreeVarName (var->INDEXED_VAR.IND_VAR);

  }
# line 1447 "Types.puma"
  {
# line 1448 "Types.puma"
   printf ("Unknown Tree in TreeVarName\n");
# line 1449 "Types.puma"
   FileUnparse (stdout, var);
# line 1450 "Types.puma"
   WriteTree (stdout, var);
  }
   return MakeIdent ("", 0);

}

tTree LastIndex
# if defined __STDC__ | defined __cplusplus
(register tTree t)
# else
(t)
 register tTree t;
# endif
{
  if (t->Kind == kBTE_LIST) {
  if (t->BTE_LIST.Next->Kind == kBTE_EMPTY) {
# line 1462 "Types.puma"
   return t->BTE_LIST.Elem;

  }
# line 1466 "Types.puma"
   return LastIndex (t->BTE_LIST.Next);

  }
  if (t->Kind == kTYPE_LIST) {
  if (t->TYPE_LIST.Next->Kind == kTYPE_EMPTY) {
# line 1470 "Types.puma"
   return t->TYPE_LIST.Elem;

  }
# line 1474 "Types.puma"
   return LastIndex (t->TYPE_LIST.Next);

  }
 yyAbort ("LastIndex");
}

void BeginTypes ()
{
}

void CloseTypes ()
{
}
