# ifndef yyShapes
# define yyShapes

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)	parameters
# else
# define ARGS(parameters)	()
# endif

# ifndef bool
# define bool char
# endif

# include "Tree.h"
# include "Definiti.h"

# line 56 "Shapes.puma"


/*********************************************************************
*                                                                    * 
*    struct  shape :   contains the bounds of array expressions      *
*                                                                    *
*     bounds[0] : ug1:og1:str1                                       *
*     bounds[1] : ug2:og2:str2                                       *
*       ....                                                         *
*     bounds[n-1] : ugn:ogn:strn                                     *
*                                                                    *
*********************************************************************/

typedef struct
 { int rank;
   int perm [MAX_DIMENSIONS];      /* permutation vector used in AdaptF77 */
   tTree bounds [MAX_DIMENSIONS] [3]; 
 } struct_shape;

typedef struct_shape* shape;



extern void SetAllocateShapes ARGS((tTree t));
extern void ResetDeallocateShapes ARGS((tTree t));
extern void SetCurrentShape ARGS((tTree t));
extern void DelCurrentShape ARGS((tTree t));
extern void GetCurrentShape ARGS((tTree t, shape s));
extern void PrintCurrentShape ARGS((shape s));
extern bool IsWholeVar ARGS((tTree t));
extern tTree NormalizeShape ARGS((tTree t));
extern tTree MakeFullShape ARGS((tTree t));
extern bool IsContiguousSection ARGS((tTree t));

extern void BeginShapes ();
extern void CloseShapes ();

# endif
