/*******************************************************************
*                                                                  *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                    *
*  Copyright   : GMD St. Augustin, Germany                         *
*  Date        : Feb 92                                            *
*  Last Update : Aug 92                                            *
*                                                                  *
*  This Module is part of the DALIB                                *
*                                                                  *
*  MAIN of ONLY NODE PROGRAM (for PVM)                             *
*                                                                  *
*  MODULE : mcube.c                                                *
*                                                                  *
*  Function: Realization of System Dependent Operations            *
*                                                                  *
*  - enrolls node in PVM                                           *
*  - initiates other node processes                                *
*  - calls nodemodule ()                                           *
*                                                                  *
*******************************************************************/

/*******************************************************************
*                                                                  *
*  Interface to Adaptor:                                           *
*                                                                  *
*    dalib_pid ()                                                  *
*    dalib_nproc ()                                                *
*                                                                  *
*******************************************************************/

#include <stdio.h>
#include <string.h>
#include "system.h"
#include "pvm3.h"

int NP;          /* number of node processes */
int my_id;       /* number of my process: 0 (host), 1 .. NP */

#define INIT_MSGID 9999

#if defined(IBM)
void nodemodule ();
#else
void nodemodule_ ();
#endif

int MAIN_ (argc, argv)
int argc;
char **argv;

{ int i, j;
  int ntasks;
  int my_tid, parent_tid;
  int me;

  unsigned long startt;   /* start timer value */
  int htrace_flag;

  my_id = 1;

  target_model = 1;   /* only nodes */

  /* enroll in PVM */

  my_tid = pvm_mytid();

  if (my_tid < 0)
      { /* there is an error , illegal tid */
        if (my_tid == PvmSysErr)
            printf ("pvmd not responding\n");
          else
            printf ("illegal tid\n");
        exit (-1);
      }

  parent_tid = pvm_parent ();

  if (parent_tid < 0)

     { /* I am the first process and have to start the other processes */

       tids [1] = my_tid;

       /* Get number of hosts of configuration */

       pvm_config (&NP, (int*) 0, (struct hostinfo**) 0);
       printf ("configuration has %d hosts\n", NP);
       eval_arg (NP, MAXP, &NP, &trace_flag);
       trace_flag = 0; /* not realized yet */

       /* create node processes */

       if (NP > 1)
           ntasks = pvm_spawn ("cube", (char**)0, PvmTaskDefault, "", 
                               NP - 1, tids+2);
         else
           ntasks = 0;
 
       if (ntasks != NP - 1)
          { if (ntasks < 0)
                printf ("node1: pvm_spawn has error code %d\n", ntasks);
              else
                printf ("node1: pvm_spawn creates only %d tasks\n", ntasks);
            exit(-1);
          } 

       for (i=2; i<=NP; i++)
         if (tids[i] < 0)
           { pvm_perror ("spawn failure");
             pvm_exit ();
             exit(-1);
           }

        /* make initial message */

        if (NP > 1)
           { pvm_initsend (PvmDataRaw);
             pvm_pkbyte (&NP, sizeof(int), 1);
             pvm_pkbyte (tids+1, NP * sizeof(int), 1); 
             pvm_mcast  (tids+2, NP-1, INIT_MSGID);
           }

        /* wait for response of nodes */

        for (i=2; i<=NP; i++)
           { pvm_recv (-1, INIT_MSGID - 1);
             pvm_upkbyte (&me, sizeof(me), 1);
             /* printf ("node process %d responded\n", me); */
           }

     }

    else 

     { /* I AM a new process */

       /* printf ("node started, tid = %d\n", my_tid); */

       /* recv initial message */

       pvm_recv (-1, INIT_MSGID);
       pvm_upkbyte (&NP, sizeof(int), 1);
       pvm_upkbyte (tids+1, NP * sizeof(int), 1);

       /* printf ("received intial message\n");  */

       /* try to find my_id */

       for (i=2; i<=NP ; i++)
          if (my_tid == tids[i]) { my_id = i; break; }

       /* printf ("here is node %d of %d\n", my_id, NP); */

       /* tell host that I am ready */

       pvm_initsend (PvmDataRaw);
       pvm_pkbyte (&my_id, sizeof(int), 1);
       pvm_send (tids[1], INIT_MSGID -1);

     }

  /* for (i=1; i<=NP; i++)
     printf ("node %d: tid of node [%d] = %d\n", my_id, i, tids[i]);
  */

  /* definition of the process control block */

  pcb.i       = my_id;
  pcb.p       = NP;

  random_block_init (); 
  dalib_init_walltime ();

  /* initialization of tracing */

#if defined(IBM)
  nodemodule ();
#else
  nodemodule_ ();
#endif
  pvm_exit ();
}

/*******************************************************************
*                                                                  *
*  number and ids of processes                                     *
*                                                                  *
*******************************************************************/

int dalib_pid_ ()
{
   return (my_id);
}

int dalib_nproc_ ()
{ return (NP); }
