//====//====//====//====//====//====//====//====//====//====//
/*
	Project: Chris standard libary <shudder>
	File: "Utils.h"

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	Useful in-line Helper functions.
*/
//====//====//====//====//====//====//====//====//====//====//
#ifndef UTILS_H
	#define  UTILS_H

	inline int SIGN(signed long x){return x >> 31;}


	//inline int SIGN(signed long x){return (x<0) ? ~1 : 0;}


	#ifndef MIN
		inline int MIN(int x, int y){int t = y - x;t &= SIGN(t);return x + t;}
	#endif
	#ifndef MAX
		inline int MAX(int x, int y){int t = y - x;t &= SIGN(t);return y - t;}
	#endif
	inline void EXG(int &x,int &y){int t=x;x=y;y=t;}
	inline void SORT(int &x,int &y){int t = y - x;t &= SIGN(t);x+=t;y-=t;}
	inline void EXG32(int32 &x,int32 &y){int t=x;x=y;y=t;}
	inline void SORT32(int32 &x,int32 &y){int t = y - x;t &= SIGN(t);x+=t;y-=t;}
	inline int BND(int x,int a,int b){return MIN(MAX(x,a),b);}

	#ifndef ABS
		inline int ABS(int x){int y=SIGN(x);return y^(y+x);}
	#endif

	#ifndef NULL
		#define NULL 0L
	#endif

#endif
