//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “BMapView.h”

	Copyright © 1996-1997 Acid Software, All Rights Reserved.

	A SubClass of BView for handling input.
	(also does cached drawing and smooth scrolling)
*/
//====//====//====//====//====//====//====//====//====//====//

#ifndef BMAP_VIEW_H
	#define BMAP_VIEW_H

	#include <View.h>
	#include <Region.h>

	#include "UBuffer.h"
	#include "Actions.h"

	class CList;
	class YateWindow;
	class SMap;
	class Buff;
	class BSBar;
	class ViewBase;
	class WinStats;

	class BMapView : public BView {

	public:
						BMapView(YateWindow *,Buff*,BRect frame, char *name,BSBar *s1,BSBar *s2,port_id pp);
						virtual ~BMapView();
		virtual void    Draw(BRect updateRect);
		virtual void    MouseDown(BPoint where);
		virtual void    MouseMoved(BPoint,uint32,const BMessage*);
		virtual void    FrameResized(float new_width, float new_height);
		virtual void    Pulse();
		virtual void    KeyDown(const char *bytes, int32 numBytes);

		WinStats    *ws;

		int32           DrawThread();

		SMap        *PrepareBlit(BRect dest, BRect *src);

		void            MyScrollTo(float x,float y);
		void            MyScrollTo(int32 pos);
		void            CleanScrollers();
		void            FlickTo(float x,float y);

		void            ChangeBuff(Buff *);
		void		HalfCursor(const BRect &r);
		void        HideCursor();
		void        HideCursorNow();
		void        PlaceCursor();
		void        DrawCursor();
		void		ChangeCursor(int32 newcursor);

		int32           sscroll;
		int32		targetnum;
		float           fh,ffh;
		Buff            *cb; //Current Buffer
		BSBar           *scbv,*scbh;
		BFont           myfont;
		color_space     cspace;
		ViewBase    *vb;

	private:
		BRect   bnds;

		float       tlx,tly,wid;
		int32		ltop;

		BRegion     ScreenClean;
		BRegion     MyDirty;
		void    MyDraw();

		void            CleanScreen(BRect rr);

		void            SeekMouse();
		void            SeekCursor();
		void            SeekScrollBar();

		void            Closer(float &,float &vel,float dest,bigtime_t time);
		void            DoKeyDown(const char *bytes, int32 key,int32 modifiers);
		int32           Scribble(int32,int32,int32,int32,int32);

		int32           cstat,sleeping;
		int32           stx,sty;//for mouse-dragging

		float           prate;

		color_space uspace;
		SMap           *smp1,*smp2;       //cached drawing
		int32           lastsmp;
		int32           lastshift;
		int32            needscrolls;
		int32            smx,smy;
		int32            mouseb;
		int32            lmx,lmy,lcx,lcy;
		float           tax,tay,vvx,vvy,pox,poy;
		float           rpx,rpy;

		bigtime_t       lastscroll,mynow;
		BPoint          lastmouse;
		float           lex,ley;
		float           llx,lly;
	};

//	#define DIRTY           80
	#define SCROLL          100
//	#define CURSOR_MOVE     128
	#define SCROLLBAR_MOVE  160
//	#define TEXT_CHANGE     256
//	#define SEL_CHANGE      256

#endif //BMAPVIEW_H

