# Makefile fragment for pdfTeX and web2c. --infovore@xs4all.nl. Public domain.
# This fragment contains the parts of the makefile that are most likely to
# differ between releases of pdfTeX.

# The libraries are not mentioned.  As the matter stands, a change in their
# number or how they are configured requires changes to the main distribution
# anyway.

Makefile: $(srcdir)/pdftexdir/pdftex.make

# The C sources.
pdftex_c = pdftexini.c pdftex0.c pdftex1.c pdftex2.c
pdftex_o = pdftexini.o pdftex0.o pdftex1.o pdftex2.o pdftexextra.o

# Generation of the web and ch files.
pdftex.web: tie tex.web tex.ch pdftexdir/pdftex.ch
	./tie -m pdftex.web $(srcdir)/tex.web $(srcdir)/tex.ch \
         $(srcdir)/pdftexdir/pdftex.ch
pdftex.ch: 
	-rm -f pdftex.ch
	cp /dev/null pdftex.ch

pdftex-cross: $(web2c_programs)
	@if test "x${linux_build_dir}" = x; then echo Error: linux_build_dir not set; exit -1; fi
	rm -f web2c/fixwrites web2c/splitup web2c/web2c
	ln -s ${linux_build_dir}/web2c/web2c/fixwrites web2c
	ln -s ${linux_build_dir}/web2c/web2c/splitup web2c
	ln -s ${linux_build_dir}/web2c/web2c/web2c web2c
	touch web2c/fixwrites web2c/splitup web2c/web2c
	make tie; rm -f tie
	ln -s ${linux_build_dir}/web2c/tie .; touch tie
	make tangleboot; rm -f tangleboot
	ln -s ${linux_build_dir}/web2c/tangleboot .; touch tangleboot
	make tangle; rm -f tangle
	ln -s ${linux_build_dir}/web2c/tangle .; touch tangle
	make pdftex

# end of pdftex.make
