//	StripApp.cpp

#include "StripApp.h"
#include "StripWindow.h"
#include <Directory.h>
#include <Entry.h>

const char *StripApp::signature = "application/x-vnd.Be-Strip";
const char *StripApp::moduleFolderName = "modules";

StripApp::StripApp()
	: BApplication(signature)
{
}

void StripApp::ReadyToRun(void)
{
	status_t err;
	StripWindow *window;
	ModuleView *moduleView;
	app_info appInfo;
	BEntry appEntry;
	BEntry moduleEntry;
	BDirectory appFolder;
	BDirectory moduleFolder;

	window = new StripWindow();
	err = GetAppInfo(&appInfo);
	if (err != B_OK)
		goto bail;
	err = appEntry.SetTo(&appInfo.ref,true);
	if (err != B_NO_ERROR)
		goto bail;
	err = appEntry.GetParent(&appFolder);
	if (err != B_NO_ERROR)
		goto bail;
	err = moduleFolder.SetTo(&appFolder,moduleFolderName);
	if (err != B_OK)
	{
		err = appFolder.CreateDirectory(moduleFolderName,&moduleFolder);
		if (err != B_OK)
			goto bail;
	}
	moduleFolder.Rewind();
	while (moduleFolder.GetNextEntry(&moduleEntry,true) == B_NO_ERROR)
	{
		moduleView = ModuleView::LoadModule(&moduleEntry);
		if (moduleView)
			window->AddModule(moduleView);
	}
bail:
	window->Show();
}