#
# This file is auto-generated. ***ANY*** changes here will be lost
#

package Errno;
use vars qw(@EXPORT_OK %EXPORT_TAGS @ISA $VERSION %errno $AUTOLOAD);
use Exporter ();
use Config;
use strict;

$Config{'myarchname'} eq "BePC-beos" or
	die "Errno architecture (BePC-beos) does not match executable architecture ($Config{'myarchname'})";

$VERSION = "1.111";
@ISA = qw(Exporter);

@EXPORT_OK = qw(ENOSYS EFAULT ENETDOWN EAFNOSUPPORT EALREADY EMSGSIZE
	ENOEXEC ECHILD ENOENT EDEADLK ENOERR EISCONN ERANGE EEXIST
	ECONNABORTED ESIGPARM EOVERFLOW EXDEV EFPOS ESTALE ELOOP EISDIR
	ECONNREFUSED ESHUTDOWN ENODEV ENOTTY EADDRINUSE ENOTEMPTY ESPIPE
	ENOPROTOOPT E2BIG ENOMSG ENETUNREACH EPIPE ENOTDIR ECONNRESET EFBIG
	EIO EXPR_NEST_MAX EADDRNOTAVAIL EINVAL EROFS EILSEQ EACCES ENOTCONN
	EAGAIN ENOSPC ENAMETOOLONG EHOSTUNREACH EMFILE EBADF ENOBUFS ENFILE
	EPFNOSUPPORT EWOULDBLOCK ENOLCK EMLINK ENOMEM EINTR ENXIO
	EQUIV_CLASS_MAX EDOM EBUSY ENETRESET ETIMEDOUT EINPROGRESS
	EPROTONOSUPPORT ESRCH EPERM EPROTOTYPE EOPNOTSUPP EOK);
	
%EXPORT_TAGS = (
    POSIX => [qw(
	E2BIG EACCES EADDRINUSE EADDRNOTAVAIL EAFNOSUPPORT EAGAIN EALREADY
	EBADF EBUSY ECHILD ECONNABORTED ECONNREFUSED ECONNRESET EDEADLK EDOM
	EEXIST EFAULT EFBIG EHOSTUNREACH EINPROGRESS EINTR EINVAL EIO EISCONN
	EISDIR ELOOP EMFILE EMLINK EMSGSIZE ENAMETOOLONG ENETDOWN ENETRESET
	ENETUNREACH ENFILE ENOBUFS ENODEV ENOENT ENOEXEC ENOLCK ENOMEM
	ENOPROTOOPT ENOSPC ENOSYS ENOTCONN ENOTDIR ENOTEMPTY ENOTTY ENXIO
	EOPNOTSUPP EPERM EPFNOSUPPORT EPIPE EPROTONOSUPPORT EPROTOTYPE ERANGE
	EROFS ESHUTDOWN ESPIPE ESRCH ESTALE ETIMEDOUT EWOULDBLOCK
	EXDEV
    )]
);

sub ENOSYS () { 0 }
sub EFAULT () { 0 }
sub ENETDOWN () { 0 }
sub EAFNOSUPPORT () { 0 }
sub EALREADY () { 0 }
sub EMSGSIZE () { 0 }
sub ENOEXEC () { 0 }
sub ECHILD () { 0 }
sub ENOENT () { 0 }
sub EDEADLK () { 0 }
sub ENOERR () { 0 }
sub EISCONN () { 0 }
sub ERANGE () { 0 }
sub EEXIST () { 0 }
sub ECONNABORTED () { 0 }
sub ESIGPARM () { 0 }
sub EOVERFLOW () { 0 }
sub EXDEV () { 0 }
sub EFPOS () { 0 }
sub ESTALE () { 0 }
sub ELOOP () { 0 }
sub EISDIR () { 0 }
sub ECONNREFUSED () { 0 }
sub ESHUTDOWN () { 0 }
sub ENODEV () { 0 }
sub ENOTTY () { 0 }
sub EADDRINUSE () { 0 }
sub ENOTEMPTY () { 0 }
sub ESPIPE () { 0 }
sub ENOPROTOOPT () { 0 }
sub E2BIG () { 0 }
sub ENOMSG () { 0 }
sub ENETUNREACH () { 0 }
sub EPIPE () { 0 }
sub ENOTDIR () { 0 }
sub ECONNRESET () { 0 }
sub EFBIG () { 0 }
sub EIO () { 0 }
sub EADDRNOTAVAIL () { 0 }
sub EINVAL () { 0 }
sub EROFS () { 0 }
sub EILSEQ () { 0 }
sub EACCES () { 0 }
sub ENOTCONN () { 0 }
sub EAGAIN () { 0 }
sub ENOSPC () { 0 }
sub ENAMETOOLONG () { 0 }
sub EHOSTUNREACH () { 0 }
sub EMFILE () { 0 }
sub EBADF () { 0 }
sub ENOBUFS () { 0 }
sub ENFILE () { 0 }
sub EPFNOSUPPORT () { 0 }
sub EWOULDBLOCK () { 0 }
sub ENOLCK () { 0 }
sub EMLINK () { 0 }
sub ENOMEM () { 0 }
sub EINTR () { 0 }
sub ENXIO () { 0 }
sub EDOM () { 0 }
sub EBUSY () { 0 }
sub ENETRESET () { 0 }
sub ETIMEDOUT () { 0 }
sub EINPROGRESS () { 0 }
sub EPROTONOSUPPORT () { 0 }
sub ESRCH () { 0 }
sub EPERM () { 0 }
sub EPROTOTYPE () { 0 }
sub EOPNOTSUPP () { 0 }
sub EOK () { 0 }
sub EXPR_NEST_MAX () { 32 }
sub EQUIV_CLASS_MAX () { 255 }

sub TIEHASH { bless [] }

sub FETCH {
    my ($self, $errname) = @_;
    my $proto = prototype("Errno::$errname");
    if (defined($proto) && $proto eq "") {
	no strict 'refs';
        return $! == &$errname;
    }
    require Carp;
    Carp::confess("No errno $errname");
} 

sub STORE {
    require Carp;
    Carp::confess("ERRNO hash is read only!");
}

*CLEAR = \&STORE;
*DELETE = \&STORE;

sub NEXTKEY {
    my($k,$v);
    while(($k,$v) = each %Errno::) {
	my $proto = prototype("Errno::$k");
	last if (defined($proto) && $proto eq "");
	
    }
    $k
}

sub FIRSTKEY {
    my $s = scalar keys %Errno::;
    goto &NEXTKEY;
}

sub EXISTS {
    my ($self, $errname) = @_;
    my $proto = prototype($errname);
    defined($proto) && $proto eq "";
}

tie %!, __PACKAGE__;

1;
__END__

=head1 NAME

Errno - System errno constants

=head1 SYNOPSIS

    use Errno qw(EINTR EIO :POSIX);

=head1 DESCRIPTION

C<Errno> defines and conditionally exports all the error constants
defined in your system C<errno.h> include file. It has a single export
tag, C<:POSIX>, which will export all POSIX defined error numbers.

C<Errno> also makes C<%!> magic such that each element of C<%!> has a non-zero
value only if C<$!> is set to that value, eg

    use Errno;
    
    unless (open(FH, "/fangorn/spouse")) {
        if ($!{ENOENT}) {
            warn "Get a wife!\n";
        } else {
            warn "This path is barred: $!";
        } 
    } 

=head1 AUTHOR

Graham Barr <gbarr@pobox.com>

=head1 COPYRIGHT

Copyright (c) 1997-8 Graham Barr. All rights reserved.
This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

