#!/bin/sh

# PeoplePorter shell script by Scot Hacker, 2/98.

# people.sh will take plain text output from your PIM or database that's been mail-merged 
# into a format similar to the included input.txt file and spit out corresponding Be People
# files. See the included readme.txt for for full instructions.
# This is freeware, but if this script was useful to you, send some email
# and let me know: beos@birdhouse.org . 


# The first line splits the mail-merged text file containing all of your records
# into tons of individual text files prior to adding attributes and file signatures.
# The order of the fields in your input database is not important. **However** :
# the csplit line below looks for the company: field as the first entry in each block.
# You're free to use some other designated first block, just edit the csplit line
# below to match the name of your chosen field.


echo Splitting your database into individual files \(byte sizes reported\).
echo
csplit -z -f cooked/person raw/input.txt /'company:'/ {*}  
echo
echo Preparing to loop through individual files and assign attributes.


# Now just loop through the new collection of files and create corresponding 
# People files based on the found data. 


for i in cooked/person* 
do
echo

# Extract the first and last names first so we can report
# what we're doing.

grep -w ^last: $i> /tmp/peeps.sh.last
read pre last < /tmp/peeps.sh.last
grep -w ^first: $i> /tmp/peeps.sh.first
read pre first < /tmp/peeps.sh.first
echo Starting "$first $last"
touch cooked/"$first $last"

# Set the MIME type
echo Setting signature
addattr -t MIME BEOS:TYPE application/x-person cooked/"$first $last"

# Most PIMs keep the first and last name separate,
# so we'll have to concatenate them here.
echo Adding concatenated name field: "$first $last"
addattr META:name "$last, $first" cooked/"$first $last"


# Get and add  company
grep -w ^company: $i> /tmp/peeps.sh.company
read pre company < /tmp/peeps.sh.company
echo Adding company: $company
addattr META:company "$company" cooked/"$first $last"


# Get and add  address
grep -w ^address: $i> /tmp/peeps.sh.address
read pre address < /tmp/peeps.sh.address
echo Adding address: $address
addattr META:address "$address" cooked/"$first $last"


# Get and add  city
grep -w ^city: $i> /tmp/peeps.sh.city
read pre city < /tmp/peeps.sh.city
echo Adding city: $city
addattr META:city "$city" cooked/"$first $last"


# Get and add  state
grep -w ^state: $i> /tmp/peeps.sh.state
read pre state < /tmp/peeps.sh.state
echo Adding state: $state
addattr META:state "$state" cooked/"$first $last"

# Get and add  zip
grep -w ^zip: $i> /tmp/peeps.sh.zip
read pre zip < /tmp/peeps.sh.zip
echo Adding zip: $zip
addattr META:zip "$zip" cooked/"$first $last"


# Get and add  country
grep -w ^country: $i> /tmp/peeps.sh.country
read pre country < /tmp/peeps.sh.country
echo Adding country: $country
addattr META:country "$country" cooked/"$first $last"

# Get and add  hphone
grep -w ^hphone: $i> /tmp/peeps.sh.hphone
read pre hphone < /tmp/peeps.sh.hphone
echo Adding hphone: $hphone
addattr META:hphone "$hphone" cooked/"$first $last"


# Get and add  wphone
grep -w ^wphone: $i> /tmp/peeps.sh.wphone
read pre wphone < /tmp/peeps.sh.wphone
echo Adding wphone: $wphone
addattr META:wphone "$wphone" cooked/"$first $last"

# Get and add  fax
grep -w ^fax: $i> /tmp/peeps.sh.fax
read pre fax < /tmp/peeps.sh.fax
echo Adding fax: $fax
addattr META:fax "$fax" cooked/"$first $last"


# Get and add  email
grep -w ^email: $i> /tmp/peeps.sh.email
read pre email < /tmp/peeps.sh.email
echo Adding email: $email
addattr META:email "$email" cooked/"$first $last"


# Get and add  url
grep -w ^url: $i> /tmp/peeps.sh.url
read pre url < /tmp/peeps.sh.url
echo Adding url: $url
addattr META:url "$url" cooked/"$first $last"


# Get and add  group
grep -w ^group: $i> /tmp/peeps.sh.group
read pre group < /tmp/peeps.sh.group
echo Adding group: $group
addattr META:group "$group" cooked/"$first $last"


# Get and add  nickname
grep -w ^nickname: $i> /tmp/peeps.sh.nickname
read pre nickname < /tmp/peeps.sh.nickname
echo Adding nickname: $nickname
addattr META:nickname "$nickname" cooked/"$first $last"


# Finished. 
done

# Clean up after ourselves.
rm /tmp/peeps.sh.*
rm cooked/person*

echo
echo Finished translating. Open the \"cooked\" folder to QA your new People files.
echo If they came out done, just drag them into /boot/home/People.
