/*  
	BeOS Front-end of PDF file reader xpdf.
    Copyright (C) 1997 Benoit Triquet
    Copyright (C) 1998-99 Hubert Figuiere
	Copyright (C) 2000 Michael Pfeiffer
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "StatusWindow.h"
#include <StringView.h>

StatusWindow::StatusWindow(const char *text, BRect aRect) 
	: BWindow(aRect, "PDFViewer Status", 
		B_MODAL_WINDOW , 
		B_NOT_RESIZABLE|B_NOT_ZOOMABLE|B_NOT_CLOSABLE) {
	BString s("PDFViewer reading file: ");
	s += text;
	// center window
	aRect.OffsetBy(aRect.Width() / 2, aRect.Height() / 2);
	float width = 300, height = 30;
	aRect.SetRightBottom(BPoint(aRect.left + width, aRect.top + height));
	aRect.OffsetBy(-aRect.Width() / 2, -aRect.Height() / 2);
	// view for the background color
	BRect rect(0, 0, width, height);
	BView *view = new BView(rect, "status_view", B_FOLLOW_NONE, 0);
	view->SetViewColor(225, 225, 255, 255);

	BStringView *stringView = new BStringView(BRect(0, 0, width, 20), 
											"label", s.String());
	// stringView->SetViewColor(128, 128, 128, 255);
	stringView->SetAlignment(B_ALIGN_CENTER);
	view->AddChild(stringView);
	AddChild(view);
	
	MoveTo(aRect.left, aRect.top);
	ResizeTo(width, height);
	Show();
}
