// TrackView.h (nanodot)
// e.moon 27apr98

#pragma once
#include <View.h>
#include <SupportKit.h>

#include "Track.h"

class TrackView : public BView {
public: // MESSAGES
	enum trackview_msg {
		TRACK_EDIT_SEQ = 'edsq',
		TRACK_SET_PITCH = 'edpt'
	};

public: // METHODS
	TrackView(Track& track, BRect frame);
	~TrackView();

	// fetch track	
	Track* getTrack() { return &m_track; }
	
	// handle edit messages:
	virtual void handleEditSeq(BMessage* pMsg);
	virtual void handleSetPitch(BMessage* pMsg);
	
	// extends AllAttached():
	// targets controls in m_controls to this view
	void AllAttached();
	
	void MessageReceived(BMessage* pMsg);

	// painting
	void Draw(BRect rect);
	
protected: // HELPERS
	void buildNoteMenu(BMenu* pMenu); // NYI
	
private: // IMPLEMENTATION
	Track& m_track;
	
	BMenuField* m_pNoteField;
	BList m_controls;
	BRect m_menuRect;
};

// END -- TrackView.h --