// SeqGlobalView.h (nanodot)
// e.moon apr98

#pragma once
#include <View.h>
#include <SupportKit.h>
#include <string.h>

#include "SeqGlobal.h"

class SeqGlobalView : public BView {
public: // MESSAGES
	enum seqglobalview_msg {
		SEQGLOBAL_SET_PORT = 'sprt',
		SEQGLOBAL_SET_CHANNEL = 'schn',
		SEQGLOBAL_STARTSTOP = 'stst',
		SEQGLOBAL_MUTE = 'mute',
		SEQGLOBAL_CLONE = 'clon'
	};


public: // METHODS
	SeqGlobalView(SeqGlobal& seqGlobal, BRect frame);
	~SeqGlobalView();

	// handle events:
	virtual void handleStartStop(BMessage* pMsg);
	virtual void handleMute(BMessage* pMsg);
	virtual void handleSetPort(BMessage* pMsg);
	virtual void handleSetChannel(BMessage* pMsg);

	// set up (AllAttached) and handle (MessageReceived) control messages	
	void AllAttached();
	void MessageReceived(BMessage*);
	
	// draw the view's border
	void Draw(BRect rect);
	
protected: // HELPERS

	// populates the given menu from the given list, sending
	// 
	static void addPortMenuItems(BMenu* pMenu, BList& list);
	
	static void addChannelMenuItems(BMenu* pMenu);
	
private: // IMPLEMENTATION


	
	SeqGlobal& m_seqGlobal;
	
	// the port & channel menu fields:
	BMenuField* m_pPortField,* m_pChannelField;
	
	// the start/stop button:
	BButton* m_pStartStopButton;
	
	// the mute button:
	BButton* m_pMuteButton;
	
	// the clone button:
	BButton* m_pCloneButton;
};

// -- end SeqGlobalView.h