// NanoDotApp.cpp (nanodot)
// e.moon apr98

#include <stdio.h>
#include <Application.h>
#include "NanoDotApp.h"
#include "NanoDotWindow.h"
#include "NanoError.h"

int main() {
	NanoDotApp app;
	app.Run();
	return 0;
}

//---------------------------------------------------------------//

// c'tor: starts app by adding an initial window:
NanoDotApp::NanoDotApp() :
	BApplication("application/x-vnd.eamoon-nanodot-r1") {
	
	addWindow(new NanoDotWindow());
}

// adds a window to the internal window-list:
void NanoDotApp::addWindow(NanoDotWindow* pWnd) {
	m_windowList.AddItem(pWnd);
}

// removes the given window; if no more exist, quits:
void NanoDotApp::removeWindow(NanoDotWindow* pWnd) {

	// remove; bail if unsuccessful:
	if(!m_windowList.RemoveItem(pWnd))
		NanoError("NanoDotApp::removeWindow(): window not in list!").displayAndQuit();

	// if that was the last window, kill myself:
	if(m_windowList.CountItems() == 0)		
		PostMessage(B_QUIT_REQUESTED);
}

// END -- NanoDotApp.cpp --