/* linux_obuffer.h

   Output buffer for Linux written by
   Louis P. Kruger (lpkruger@phoenix.princeton.edu)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef LINUX_OBUFFER_H
#define LINUX_OBUFFER_H

#if defined(LINUX) || defined(__FreeBSD__)

#include "all.h"
#include "args.h"
#include "obuffer.h"

class LinuxObuffer : public Obuffer
{
  int16  buffer[OBUFFERSIZE];
  int16 *bufferp[MAXCHANNELS];
  uint32 channels;
  static int audio_fd;

  static int open_audio_device();

public:
	LinuxObuffer (uint32 number_of_channels, MPEG_Args *maplay_args);
   ~LinuxObuffer ();

  void	append (uint32 channel, int16 value);
  void	write_buffer (int dummy);

#ifdef SEEK_STOP
  void clear_buffer();
  void set_stop_flag();
#endif // SEEK_STOP

  static BOOL class_suitable (uint32 number_of_channels);
};

#endif // LINUX || __FreeBSD__

#endif // LINUX_OBUFFER_H
