/* beos_obuffer.cc

 	Output buffer for BeOS written by Philippe Thomas
   (tphilippe@sdv.fr), using Pierre Brua's cAudioWrap class.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>

#include "args.h"
#include "obuffer.h"
#include "header.h"
#ifdef ULAW
#include "ulaw.h"
#endif

#include "beos_audiowrap.h"

BeObuffer::BeObuffer (uint32 number_of_channels)
{
#ifdef DEBUG
  if (!number_of_channels || number_of_channels > MAXCHANNELS)
  {
    cerr << "FileObuffer: number of channels has to be in [1, " <<  MAXCHANNELS << "] !\n";
    exit (1);
  }
#endif

#ifdef ULAW
  if (number_of_channels > 1)
    cerr << "Are you sure you need stereo u-law output?\n";
#endif
  channels = number_of_channels;
  audio_wrapper = new cAudioWrap(channels);
  for (int i = 0; i < number_of_channels; ++i)
    bufferp[i] = buffer + i;
}

BeObuffer::~BeObuffer(void)
{
	delete audio_wrapper;
}

void BeObuffer::append (uint32 channel, int16 value)
{
#ifdef DEBUG
  if (channel >= channels)
  {
    cerr << "illegal channelnumber in FileObuffer::append()!\n";
    exit (1);
  }
  if (bufferp[channel] - buffer >= OBUFFERSIZE)
  {
    cerr << "FileObuffer: buffer overflow!\n";
    exit (1);
  }
#endif

#ifdef ULAW
  // convert 16-bit PCM sample to 8-bit ulaw:
  *bufferp[channel] = linear2ulaw[value >> 3];
#else
  *bufferp[channel] = value;
#endif
  bufferp[channel] += channels;
}

#ifdef SEEK_STOP
void BeObuffer::clear_buffer(void)
{
}

void BeObuffer::set_stop_flag(void)
{
}
#endif // SEEK_STOP

void BeObuffer::write_buffer (int32 fd)
{
  long length = (long)((char *)bufferp[0] - (char *)buffer);

  audio_wrapper->AddData((char *)buffer, length);

  for (int i = 0; i < channels; ++i)
    bufferp[i] = buffer + i;
}

Obuffer *create_obuffer(MPEG_Args *maplay_args)
{
	Obuffer *buffer;

	enum e_mode mode = maplay_args->MPEGheader->mode();
   enum e_channels which_channels = maplay_args->which_c;

   if (mode == single_channel || which_channels != Both)
      buffer = new BeObuffer (1);
   else
      buffer = new BeObuffer (2);

   return(buffer);
}

