/*  aix_obuffer.cc

    Copied from obuffer_aix.cc from maplay 1.3b */

/*
 *  @(#) obuffer_aix.cc 1.1, last edit: 13 Feb 1995 13:13:05
 *  @(#) Copyright (C) 1993, 1994 Tobias Bading (bading@cs.tu-berlin.de)
 *  @(#) Berlin University of Technology
 *
 *  AixObuffer class written by
 *  Nick Cremelie (cremelie@ibmsp.elis.rug.ac.be)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef AIX

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <iostream.h>
#include <sys/time.h>
#include "all.h"
#include "header.h"
extern "C" {
#include <sys/audio.h>
}

#include "args.h"
#include "header.h"
#include "obuffer.h"

// statics of class AixObuffer:
int AixObuffer::audio_fd = -1;


int AixObuffer::open_audio_device (void)
{
  int fd;
  if ((fd = open ("/dev/acpa0/1", O_WRONLY)) < 3)
    if ((fd = open ("/dev/paud0/1", O_WRONLY)) < 3)
      if ((fd = open ("/dev/baud0/1", O_WRONLY)) < 3)
      {
        cerr << "Sorry, no audio device is currently available!\n";
        exit (1);
      }

  return ((fd<3)?-1:fd);
}


AixObuffer::AixObuffer (uint32 number_of_channels, MPEG_Args *maplay_args)
{

struct _track_info
{
        unsigned short master_volume;
        unsigned short dither_percent;
        unsigned short reserved[3];
} t_info;
audio_init a_init;
audio_control a_control;
audio_change a_change;

  channels = number_of_channels;
  for (int i = 0; i < number_of_channels; ++i)
    bufferp[i] = buffer + i;

  if (audio_fd < 0)
  {
    cerr << "Internal error, AixObuffer::audio_fd has to be initialized\n"
            "by AixObuffer::class_suitable()!\n";
    exit (1);
  }

  // configure the device:
  int play_sample_rate = maplay_args->MPEGheader->frequency();

  t_info.master_volume=0x7fff;
  t_info.dither_percent=0;

  a_init.srate=play_sample_rate;
  a_init.bits_per_sample=16;
  a_init.channels=channels;
  a_init.mode=PCM;
  a_init.flags=FIXED|BIG_ENDIAN|TWOS_COMPLEMENT;
  a_init.operation=PLAY;

  a_change.balance=0x3fff0000;
  a_change.balance_delay=0;
  a_change.volume=(int32)(maplay_args->volume * (float)0x7FFFFFFF);
  a_change.volume_delay=0;
  a_change.monitor=AUDIO_IGNORE;
  a_change.input=AUDIO_IGNORE;
  a_change.output=OUTPUT_1;
  a_change.dev_info=&t_info;

  a_control.ioctl_request=AUDIO_CHANGE;
  a_control.position=0;
  a_control.request_info=&a_change;

  if (ioctl(audio_fd, AUDIO_INIT, &a_init) == -1 )
  {
    perror ("configuration (init) of audio device failed");
    exit (1);
  }
  if (ioctl(audio_fd, AUDIO_CONTROL, &a_control) == -1 )
  {
    perror ("configuration (control) of audio device failed");
    exit (1);
  }

  a_control.ioctl_request=AUDIO_START;
  a_control.request_info=NULL;
  if (ioctl(audio_fd, AUDIO_CONTROL, &a_control) == -1 )
  {
    perror ("configuration (start) of audio device failed");
    exit (1);
  }
}

AixObuffer::~AixObuffer (void)
{
  if (ioctl(audio_fd, AUDIO_WAIT) == -1)
    cerr << "could not wait on audio device!\n";
  close (audio_fd);
}


void AixObuffer::append (uint32 channel, int16 value)
{
#ifdef DEBUG
  if (channel >= channels)
  {
    cerr << "illegal channelnumber in AixObuffer::append()!\n";
    exit (1);
  }
  if (bufferp[channel] - buffer >= OBUFFERSIZE)
  {
    cerr << "buffer overflow!\n";
    exit (1);
  }
#endif
  *bufferp[channel] = value;
  bufferp[channel] += channels;
}

#ifdef SEEK_STOP
void AixObuffer::clear_buffer(void)
{
}

void AixObuffer::set_stop_flag(void)
{
}
#endif // SEEK_STOP

void AixObuffer::write_buffer (int)
{
  int length = (int)((char *)bufferp[0] - (char *)buffer);
  if (write (audio_fd, buffer, length) != length)
  {
    perror ("write to audio device failed");
    exit (1);
  }
  for (int i = 0; i < channels; ++i)
    bufferp[i] = buffer + i;
}


BOOL AixObuffer::class_suitable (uint32 number_of_channels)
{
  // open the audio device:
  audio_fd = open_audio_device ();
  return True;
}

Obuffer *create_obuffer(MPEG_Args *maplay_args)
{
	Obuffer *buffer;

	enum e_mode mode = maplay_args->MPEGheader->mode();
   enum e_channels which_channels = maplay_args->which_c;

   if (AixObuffer::class_suitable (mode == single_channel ||
                                   which_channels != both) ? 1 : 2)
	   if (mode == single_channel || which_channels != both)
        buffer = new AixObuffer (1, maplay_args);
	   else
        buffer = new AixObuffer (2, maplay_args);
   else
      return(NULL);

  return(buffer);
}

#endif // AIX
