// img2icon.cpp
// © 1998 Matt Lewinski
// An application which creates icons from image files.
#include <Datatypes.h>
#include "BitmapStream.h"
#include "BitmapConversion.h"

const char kSignature[] = "application/x-vnd.lewinski-img2icon";

int main(int argc, char** argv) {
	BApplication	*theApp;
	BBitmap		*inSMap, *newSMap, *inBMap, *newBMap;
	BDirectory	*currDirectory;
	BEntry		*inSEntry, *inBEntry, *outEntry;
	BFile		*inSFile, *inBFile, *outFile;
	BNode		*outNode;
	BNodeInfo		*outNodeInfo;
	BScreen		*theScreen;
	BitmapStream	*inSStream, *inBStream;
	char			*outName, *inSName, *inBName;
	uint32		*theOldBits, theColor;
	uint8		*theNewBits, red, blue, green, alpha, index;
	
	// Check for arguments.
	if(argc <= 3) {
		printf("usage: img2icon <input small icon> <input large icon> <output icon>\n");
		return 1;
	}
	
	// Copy some args for easier access.
	inSName		= argv[1];
	inBName		= argv[2];
	outName		= argv[3];
	
	theApp		= new BApplication(kSignature);	
	theScreen 	= new BScreen();
	inSMap		= new BBitmap(BRect(0, 0, 15, 15), B_RGB_32_BIT);
	inBMap		= new BBitmap(BRect(0, 0, 31, 31), B_RGB_32_BIT);
	newSMap		= new BBitmap(BRect(0, 0, 15, 15), B_COLOR_8_BIT);
	newBMap		= new BBitmap(BRect(0, 0, 31, 31), B_COLOR_8_BIT);	
	currDirectory	= new BDirectory();
	inSEntry 		= new BEntry(inSName);
	inBEntry		= new BEntry(inBName);
	outEntry		= new BEntry(outName);

	// Get the working directory.
	inSEntry->GetParent(currDirectory);
	
	// Create the file objects.
	inSFile		= new BFile(inSEntry, B_READ_ONLY);
	inBFile		= new BFile(inBEntry, B_READ_ONLY);
	outFile 		= new BFile();

	// Make the file if we need to.
	currDirectory->CreateFile(outName, outFile, true);

	// This is how we set the icon.
	outNode		= new BNode(outEntry);
	outNodeInfo	= new BNodeInfo(outNode);
		
	// Create some streams.
	inSStream 	= new BitmapStream(inSMap);
	inBStream 	= new BitmapStream(inBMap);
	
	// Check if datatypes is present.
	if(DATAVersion == NULL) {
		printf("fatal error: DATAVersion == NULL\n");
		return 1;
	}

	// Try initialization.
	if(DATAInit(kSignature)) {
		printf("fatal error: DATAInit()\n");
		return 1;
	}
	
	// Try to grab the first bitmap.
	if(DATATranslate(*inSFile, NULL, NULL, *inSStream, DATA_BITMAP)) {
		printf("fatal error: DATATranslate() failed on first image.\n");
		return 1;
	}
		
	inSStream->DetachBitmap(inSMap);
	newSMap = BitmapTo8(inSMap);
	
	// Try to grab the second bitmap.
	if(DATATranslate(*inBFile, NULL, NULL, *inBStream, DATA_BITMAP)) {
		printf("fatal error: DATATranslate() failed on second image.\n");
		return 1;
	}
		
	inBStream->DetachBitmap(inBMap);
	newBMap = BitmapTo8(inBMap);

	// Set the icons.
	outNodeInfo->SetIcon(newSMap, B_MINI_ICON);
	outNodeInfo->SetIcon(newBMap, B_LARGE_ICON);

	printf("Icon creation sucessfully completed.\n");
	return 0;
}
