// YColorControlWindow.h
// by John Yanarella
// Copyright (c) 1999 John Yanarella, All Rights Reserved

#ifndef COLOR_PICKER_WINDOW_H
#define COLOR_PICKER_WINDOW_H

#define COLOR_FG_CHG 'fchg'
#define COLOR_BG_CHG 'bchg'
#define COLOR_QUIT   'xqit'

#include <Window.h>
#include <InterfaceKit.h>
#include "YColorControl.h"

class YColorControlWindow : public BWindow 
{
public:
   YColorControlWindow(BPoint leftTop, const char* title, bool twoSwatches = false); 
   virtual ~YColorControlWindow();

   void SetFgColor(rgb_color color);
   void SetBgColor(rgb_color color);
   void SetSelection(bool foreground);
	
   void SetTarget(BLooper* target);
   void SetModificationMessage(BMessage* returnFgMsg, BMessage* returnBgMsg = NULL);
   void SetCloseMessage(BMessage* closeMsg);
	
   virtual	bool QuitRequested();
   void MessageReceived(BMessage* message);
private:
   YColorControl *m_colorPicker;
   BLooper *m_target;
   BMessage *m_returnFgMsg, *m_returnBgMsg;
   BMessage *m_closeMsg;
};

#endif //COLOR_PICKER_WINDOW_H
