#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <Alert.h>


#include "StudioModel.h"
#include "PAKView.h"


PAKView::PAKView(BRect frame) :
   BOutlineListView(frame, "PAKView", B_SINGLE_SELECTION_LIST, B_FOLLOW_ALL)
{
   SetViewColor(216, 216, 216, 0);

   SetInvocationMessage(new BMessage(IDC_PAKVIEWER));

   ResizeTo(frame.Width()-14, frame.Height());

   scroll = new BScrollView("PAKView_ScrollView", this,
			    B_FOLLOW_ALL, 0, false, true);
}


BScrollView *PAKView::ScrollView(void)
{
   return scroll;
}


void
_makeTempFileName (char *str, const char *suffix)
{
	strcpy (str, "/tmp");
	strcat (str, "/hltempmodel");
	strcat (str, suffix);
}


int _compare(const void *arg1, const void *arg2)
{
   if (strchr ((char *) arg1, '/') && !strchr ((char *) arg2, '/'))
      return -1;
   else if (!strchr ((char *) arg1, '/') && strchr ((char *) arg2, '/'))
      return 1;  
   else
      return strcmp ((char *) arg1, (char *) arg2); 
}


int pak_ExtractFile (const char *pakFile, const char *lumpName, char *outFile)
{
   FILE *file = fopen (pakFile, "rb");
   if (!file)
      return 0;
   
   int ident, dirofs, dirlen;
   
   fread (&ident, sizeof (int), 1, file);
   if (ident != (int) (('K' << 24) + ('C' << 16) + ('A' << 8) + 'P'))
   {
      fclose (file);
      return 0;
   }
   
   fread (&dirofs, sizeof (int), 1, file);
   fread (&dirlen, sizeof (int), 1, file);
   
   fseek (file, dirofs, SEEK_SET);
   int numLumps = dirlen / 64;
   
   for (int i = 0; i < numLumps; i++)
   {
      char name[56];
      int filepos, filelen;
      
      fread (name, 56, 1, file);
      fread (&filepos, sizeof (int), 1, file);
      fread (&filelen, sizeof (int), 1, file);

      if (!strcmp (name, lumpName))
      {
	 FILE *out = fopen (outFile, "wb");
	 if (!out)
	 {
	    fclose (file);
	    return 0;
	 }
	 
	 fseek (file, filepos, SEEK_SET);
	 
	 while (filelen--)
	    fputc (fgetc (file), out);
	 
	 fclose (out);
	 fclose (file);
	 
	 return 1;
      }
   }
   
   fclose (file);
   
   return 0;
}


int PAKView::OnPAKViewer (void)
{
   BStringItem *tvi = (BStringItem *)ItemAt(CurrentSelection(0));

   if (tvi)
   {
      strcpy (d_currLumpName, tvi->Text());

      BStringItem *tviParent = (BStringItem *)Superitem(tvi);
      char tmp[128];
      while (tviParent)
      {
	 strcpy (tmp, d_currLumpName);
	 strcpy (d_currLumpName, tviParent->Text());
	 strcat (d_currLumpName, "/");
	 strcat (d_currLumpName, tmp);
	 tviParent = (BStringItem *)Superitem(tviParent);
      }

      bool d_loadEntirePAK = true;

      if (!d_loadEntirePAK)
      {
	 strcpy (tmp, d_currLumpName);
	 strcpy (d_currLumpName, "models/");
	 strcat (d_currLumpName, tmp);
      }
   }

   if (strstr(tvi->Text(), ".mdl")) {
      return 1;
   } else {
      static char str2[256];
      char suffix[16];

      if (strstr(tvi->Text(), ".wav")) strcpy(suffix, ".wav");
      else if (strstr(tvi->Text(), ".txt")) strcpy(suffix, ".txt");
      else if (strstr(tvi->Text(), ".cfg")) strcpy(suffix, ".cfg");
      else if (strstr(tvi->Text(), ".bmp")) strcpy(suffix, ".bmp");
      else if (strstr(tvi->Text(), ".tga")) strcpy(suffix, ".tga");
      else {
	 BAlert *alert;
	 alert = new BAlert("", "Unsupported file format." ,
			    "OK", NULL, NULL, B_WIDTH_AS_USUAL, B_WARNING_ALERT);
	 alert->Go();

	 return 0;
      }

      _makeTempFileName (str2, suffix);

      char syscmd[256];
      sprintf(syscmd, "/bin/rm -f %s", str2);
      system(syscmd); 

      if (!pak_ExtractFile (d_pakFile, d_currLumpName, str2)) {
	 BAlert *alert;
	 alert = new BAlert("", "Error extracting from PAK file." ,
			    "OK", NULL, NULL, B_WIDTH_AS_USUAL, B_WARNING_ALERT);
	 alert->Go();
      }

      sprintf(syscmd, "/boot/beos/system/Tracker %s", str2);
      system(syscmd);

      return 0;
   }

   return 1;
}


const char *PAKView::OnLoadModel(void)
{
   static char str2[256];
   char suffix[16];
   
   strcpy (suffix, ".mdl");
   _makeTempFileName (str2, suffix);
   
   if (!pak_ExtractFile (d_pakFile, d_currLumpName, str2)) {
      BAlert *alert;
      alert = new BAlert("", "Error extracting model from PAK file." ,
			 "OK", NULL, NULL, B_WIDTH_AS_USUAL, B_WARNING_ALERT);
      alert->Go();

      return NULL;
   }

   g_studioModel.FreeModel ();
   studiohdr_t *hdr = g_studioModel.LoadModel (str2);
   if (!hdr) return NULL;

   if (hdr->numtextures == 0) {
      char texturename[256];
      
      strcpy( texturename, d_currLumpName );
      strcpy( &texturename[strlen(texturename) - 4], "t.mdl" );
      
      strcpy (suffix, "T.mdl");
      _makeTempFileName (str2, suffix);

      if (!pak_ExtractFile (d_pakFile, texturename, str2)) {
	 g_studioModel.FreeModel ();
	 return NULL;
      }
   }

   if (hdr->numseqgroups > 1) {
      for (int i = 1; i < hdr->numseqgroups; i++) {
	 char seqgroupname[256];
	 
	 strcpy( seqgroupname, d_currLumpName );
	 sprintf( &seqgroupname[strlen(seqgroupname) - 4], "%02d.mdl", i );
	 
	 sprintf (suffix, "%02d.mdl", i);
	 _makeTempFileName (str2, suffix);

	 if (!pak_ExtractFile (d_pakFile, seqgroupname, str2)) {
	    g_studioModel.FreeModel ();
	    return NULL;
	 }
      }
   }
   
   g_studioModel.FreeModel ();

   strcpy (suffix, ".mdl");
   _makeTempFileName (str2, suffix);
   return str2;
}


bool PAKView::openPAKFile(const char *pakFile)
{
   FILE *file = fopen (pakFile, "rb");
   if (!file)
      return false;
   
   int ident, dirofs, dirlen;
   
   fread (&ident, sizeof (int), 1, file);
   if (ident != (int) (('K' << 24) + ('C' << 16) + ('A' << 8) + 'P')) {
      BAlert *alert;
      alert = new BAlert("", "Error opening PAK file." ,
			 "OK", NULL, NULL, B_WIDTH_AS_USUAL, B_WARNING_ALERT);
      alert->Go();

      fclose (file);
      return false;
   }
   
   fread (&dirofs, sizeof (int), 1, file);
   fread (&dirlen, sizeof (int), 1, file);
   int numLumps = dirlen / 64;
   
   fseek (file, dirofs, SEEK_SET);
   lump_t *lumps = new lump_t[numLumps];
   if (!lumps) {
      fclose (file);
      return false;
   }
   
   fread (lumps, sizeof (lump_t), numLumps, file);
   fclose (file);
   
   qsort (lumps, numLumps, sizeof (lump_t), _compare);
   
   strcpy (d_pakFile, pakFile);

   char namestack[32][32];
   BStringItem *tvistack[32];

   for (int k = 0; k < 32; k++) {
      strcpy (namestack[k], "");
      tvistack[k] = 0;
   }

   bool d_loadEntirePAK = true;

   for (int i = 0; i < numLumps; i++) {
      if (d_loadEntirePAK || !strncmp (lumps[i].name, "models", 6)) {
	 char *tok;
	 if (d_loadEntirePAK)
	    tok = &lumps[i].name[0];
	 else
	    tok = &lumps[i].name[7];
	 
	 int i = 1;
	 while (tok) {
	    char *end = strchr (tok, '/');
	    if (end)
	       *end = '\0';

	    if (strcmp (namestack[i], tok)) {
	       strcpy (namestack[i], tok);
	       if (i == 1) {
		  AddItem(tvistack[i] = new BStringItem(tok));
	       } else {
		  AddUnder(tvistack[i] = new BStringItem(tok), tvistack[i - 1]);
	       }

	       Collapse(tvistack[i]);

	       for (int j = i + 1; j < 32; j++) {
		  strcpy (namestack[j], "");
		  tvistack[j] = 0;
	       }
	    }

	    ++i;

	    if (end)
	       tok = end + 1;
	    else
	       tok = 0;
	 }
      }
   }
   
   delete[] lumps;
   
   return true;
}
