#include <Menu.h>
#include <MenuItem.h>


#include "StudioModel.h"
#include "ViewerSettings.h"
#include "MenuView.h"


MenuView::MenuView(void) : BMenuBar(BRect( 0, 0, 0, 0 ), "MenuView")
{
   BMenu *menu;
   BMenuItem *item;

   menu = new BMenu( "File" );

   AddItem( menu );

   menu->AddItem(new BMenuItem( "Load Model" B_UTF8_ELLIPSIS,
				new BMessage(IDC_FILE_LOADMODEL)));
   
   menu->AddItem(new BSeparatorItem);
   
   menu->AddItem(new BMenuItem( "Load Background Texture" B_UTF8_ELLIPSIS,
				new BMessage(IDC_FILE_LOADBACKGROUNDTEX)));

   menu->AddItem(new BMenuItem( "Load Ground Texture" B_UTF8_ELLIPSIS,
				new BMessage(IDC_FILE_LOADGROUNDTEX)));

   menu->AddItem(new BMenuItem( "Unload Ground Texture",
				new BMessage(IDC_FILE_UNLOADGROUNDTEX)));

   menu->AddItem(new BSeparatorItem);

   menu->AddItem(new BMenuItem( "Open PAK file" B_UTF8_ELLIPSIS,
				new BMessage(IDC_FILE_OPENPAKFILE)));

   menu->AddItem(new BMenuItem( "Close PAK file" B_UTF8_ELLIPSIS,
				new BMessage(IDC_FILE_CLOSEPAKFILE)));

   menu->AddItem(new BSeparatorItem);

   menu->AddItem(new BMenuItem( "Quit", new BMessage(B_QUIT_REQUESTED)));

   menu = new BMenu( "Options" );

   AddItem( menu );

   menu->AddItem(new BMenuItem( "Background and Ground Colors" B_UTF8_ELLIPSIS,
				new BMessage(IDC_OPTIONS_COLOR_BG_G)));

   menu->AddItem(new BMenuItem( "Light Color" B_UTF8_ELLIPSIS,
				new BMessage(IDC_OPTIONS_COLORLIGHT)));

   menu->AddItem(new BSeparatorItem);

   menu->AddItem(new BMenuItem( "Center View",
				new BMessage(IDC_OPTIONS_CENTERVIEW)));

   menu = new BMenu( "Help" );

   AddItem( menu );

   menu->AddItem(new BMenuItem( "Goto Home Page" B_UTF8_ELLIPSIS, 
				new BMessage(IDC_HELP_GOTOHOMEPAGE)));

   menu->AddItem(new BSeparatorItem);

   menu->AddItem(new BMenuItem( "About" B_UTF8_ELLIPSIS, new BMessage(IDC_HELP_ABOUT)));
}
