#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ByteOrder.h>


#include "BigEndianFix.h"


void FixVec3(vec3_t &arg)
{
   arg[0] = B_LENDIAN_TO_HOST_FLOAT(arg[0]);
   arg[1] = B_LENDIAN_TO_HOST_FLOAT(arg[1]);
   arg[2] = B_LENDIAN_TO_HOST_FLOAT(arg[2]);
}


int FixMDLHdr(studiohdr_t *hdr)
{
   hdr->version = B_LENDIAN_TO_HOST_INT32(hdr->version);
   PSTR(hdr->name);
   hdr->length = B_LENDIAN_TO_HOST_INT32(hdr->length);

   FixVec3(hdr->eyeposition);
   FixVec3(hdr->min);
   FixVec3(hdr->max);

   FixVec3(hdr->bbmin);
   FixVec3(hdr->bbmax);

   hdr->flags = B_LENDIAN_TO_HOST_INT32(hdr->flags);

   hdr->numbones = B_LENDIAN_TO_HOST_INT32(hdr->numbones);
   PINT(hdr->numbones);
   hdr->boneindex = B_LENDIAN_TO_HOST_INT32(hdr->boneindex);
   PINT(hdr->boneindex);

   hdr->numbonecontrollers = B_LENDIAN_TO_HOST_INT32(hdr->numbonecontrollers);
   PINT(hdr->numbonecontrollers);
   hdr->bonecontrollerindex = B_LENDIAN_TO_HOST_INT32(hdr->bonecontrollerindex);
   PINT(hdr->bonecontrollerindex);

   hdr->numhitboxes = B_LENDIAN_TO_HOST_INT32(hdr->numhitboxes);
   PINT(hdr->numhitboxes);
   hdr->hitboxindex = B_LENDIAN_TO_HOST_INT32(hdr->hitboxindex);
   PINT(hdr->hitboxindex);

   hdr->numseq = B_LENDIAN_TO_HOST_INT32(hdr->numseq);
   PINT(hdr->numseq);
   hdr->seqindex = B_LENDIAN_TO_HOST_INT32(hdr->seqindex);
   PINT(hdr->seqindex);

   hdr->numseqgroups = B_LENDIAN_TO_HOST_INT32(hdr->numseqgroups);
   PINT(hdr->numseqgroups);
   hdr->seqgroupindex = B_LENDIAN_TO_HOST_INT32(hdr->seqgroupindex);
   PINT(hdr->seqgroupindex);

   hdr->numtextures = B_LENDIAN_TO_HOST_INT32(hdr->numtextures);
   PINT(hdr->numtextures);
   hdr->textureindex = B_LENDIAN_TO_HOST_INT32(hdr->textureindex);
   PINT(hdr->textureindex);
   hdr->texturedataindex = B_LENDIAN_TO_HOST_INT32(hdr->texturedataindex);
   PINT(hdr->texturedataindex);

   hdr->numskinref = B_LENDIAN_TO_HOST_INT32(hdr->numskinref);
   PINT(hdr->numskinref);
   hdr->numskinfamilies = B_LENDIAN_TO_HOST_INT32(hdr->numskinfamilies);
   PINT(hdr->numskinfamilies);
   hdr->skinindex = B_LENDIAN_TO_HOST_INT32(hdr->skinindex);
   PINT(hdr->skinindex);

   hdr->numbodyparts = B_LENDIAN_TO_HOST_INT32(hdr->numbodyparts);
   PINT(hdr->numbodyparts);
   hdr->bodypartindex = B_LENDIAN_TO_HOST_INT32(hdr->bodypartindex);
   PINT(hdr->bodypartindex);

   hdr->numattachments = B_LENDIAN_TO_HOST_INT32(hdr->numattachments);
   PINT(hdr->numattachments);
   hdr->attachmentindex = B_LENDIAN_TO_HOST_INT32(hdr->attachmentindex);
   PINT(hdr->attachmentindex);

   hdr->soundtable = B_LENDIAN_TO_HOST_INT32(hdr->soundtable);
   hdr->soundindex = B_LENDIAN_TO_HOST_INT32(hdr->soundindex);
   hdr->soundgroups = B_LENDIAN_TO_HOST_INT32(hdr->soundgroups);
   hdr->soundgroupindex = B_LENDIAN_TO_HOST_INT32(hdr->soundgroupindex);

   hdr->numtransitions = B_LENDIAN_TO_HOST_INT32(hdr->numtransitions);
   PINT(hdr->numtransitions);
   hdr->transitionindex = B_LENDIAN_TO_HOST_INT32(hdr->transitionindex);
   PINT(hdr->transitionindex);

   return 0;
}


int FixMDLBone(mstudiobone_t *bone)
{
   PSTR(bone->name);

   bone->parent = B_LENDIAN_TO_HOST_INT32(bone->parent);
   bone->flags = B_LENDIAN_TO_HOST_INT32(bone->flags);

   for (int i=0; i<6; i++) {
      bone->bonecontroller[i] = B_LENDIAN_TO_HOST_INT32(bone->bonecontroller[i]);
      bone->value[i] = B_LENDIAN_TO_HOST_FLOAT(bone->value[i]);
      bone->scale[i] = B_LENDIAN_TO_HOST_FLOAT(bone->scale[i]);
   }

   return 0;
}


int FixMDLBoneController(mstudiobonecontroller_t *bonecontroller)
{
   bonecontroller->bone = B_LENDIAN_TO_HOST_INT32(bonecontroller->bone);
   bonecontroller->type = B_LENDIAN_TO_HOST_INT32(bonecontroller->type);
   bonecontroller->start = B_LENDIAN_TO_HOST_FLOAT(bonecontroller->start);
   bonecontroller->end = B_LENDIAN_TO_HOST_FLOAT(bonecontroller->end);
   bonecontroller->rest = B_LENDIAN_TO_HOST_INT32(bonecontroller->rest);
   bonecontroller->index = B_LENDIAN_TO_HOST_INT32(bonecontroller->index);

   return 0;
}


int FixMDLBBox(mstudiobbox_t *bbox)
{
   bbox->bone = B_LENDIAN_TO_HOST_INT32(bbox->bone);
   bbox->group = B_LENDIAN_TO_HOST_INT32(bbox->group);
   FixVec3(bbox->bbmin);
   FixVec3(bbox->bbmax);

   return 0;
}


int FixMDLSeqGroup(mstudioseqgroup_t *seqgroup)
{
   PSTR(seqgroup->label);
   PSTR(seqgroup->name);

   seqgroup->data = B_LENDIAN_TO_HOST_INT32(seqgroup->data);
   PINT(seqgroup->data);

   return 0;
}


int FixMDLSeqDesc(studiohdr_t *hdr, mstudioseqdesc_t *seqdesc)
{
   PSTR(seqdesc->label);

   seqdesc->fps = B_LENDIAN_TO_HOST_FLOAT(seqdesc->fps);
   seqdesc->flags = B_LENDIAN_TO_HOST_INT32(seqdesc->flags);

   seqdesc->activity = B_LENDIAN_TO_HOST_INT32(seqdesc->activity);
   seqdesc->actweight = B_LENDIAN_TO_HOST_INT32(seqdesc->actweight);

   seqdesc->numevents = B_LENDIAN_TO_HOST_INT32(seqdesc->numevents);
   PINT(seqdesc->numevents);
   seqdesc->eventindex = B_LENDIAN_TO_HOST_INT32(seqdesc->eventindex);
   PINT(seqdesc->eventindex);

   seqdesc->numframes = B_LENDIAN_TO_HOST_INT32(seqdesc->numframes);
   PINT(seqdesc->numframes);

   seqdesc->numpivots = B_LENDIAN_TO_HOST_INT32(seqdesc->numpivots);
   PINT(seqdesc->numpivots);
   seqdesc->pivotindex = B_LENDIAN_TO_HOST_INT32(seqdesc->pivotindex);
   PINT(seqdesc->pivotindex);

   seqdesc->motiontype = B_LENDIAN_TO_HOST_INT32(seqdesc->motiontype);
   seqdesc->motionbone = B_LENDIAN_TO_HOST_INT32(seqdesc->motionbone);
   FixVec3(seqdesc->linearmovement);
   seqdesc->automoveposindex = B_LENDIAN_TO_HOST_INT32(seqdesc->automoveposindex);
   seqdesc->automoveangleindex = B_LENDIAN_TO_HOST_INT32(seqdesc->automoveangleindex);

   FixVec3(seqdesc->bbmin);
   FixVec3(seqdesc->bbmax);

   seqdesc->numblends = B_LENDIAN_TO_HOST_INT32(seqdesc->numblends);
   PINT(seqdesc->numblends);

   seqdesc->animindex = B_LENDIAN_TO_HOST_INT32(seqdesc->animindex);
   PINT(seqdesc->animindex);

   int i;

   for (i=0; i<2; i++) {
      seqdesc->blendtype[i] = B_LENDIAN_TO_HOST_INT32(seqdesc->blendtype[i]);
      seqdesc->blendstart[i] = B_LENDIAN_TO_HOST_FLOAT(seqdesc->blendstart[i]);
      seqdesc->blendend[i] = B_LENDIAN_TO_HOST_FLOAT(seqdesc->blendend[i]);
   }

   seqdesc->blendparent = B_LENDIAN_TO_HOST_INT32(seqdesc->blendparent);
   seqdesc->seqgroup = B_LENDIAN_TO_HOST_INT32(seqdesc->seqgroup);
   PINT(seqdesc->seqgroup);

   seqdesc->entrynode = B_LENDIAN_TO_HOST_INT32(seqdesc->entrynode);
   seqdesc->exitnode = B_LENDIAN_TO_HOST_INT32(seqdesc->exitnode);
   seqdesc->nodeflags = B_LENDIAN_TO_HOST_INT32(seqdesc->nodeflags);

   seqdesc->nextseq = B_LENDIAN_TO_HOST_INT32(seqdesc->nextseq);

   mstudioevent_t *event;
   event = (mstudioevent_t *)((char *)hdr + seqdesc->eventindex);
   for(i=0; i<seqdesc->numevents; i++, event++)
      FixMDLEvent(event);

   mstudiopivot_t *pivot;
   pivot = (mstudiopivot_t *)((char *)hdr + seqdesc->pivotindex);
   for(i=0; i<seqdesc->numpivots; i++, pivot++)
      FixMDLPivot(pivot);

   return 0;
}


int FixMDLEvent(mstudioevent_t *event)
{
   event->frame = B_LENDIAN_TO_HOST_INT32(event->frame);
   event->event = B_LENDIAN_TO_HOST_INT32(event->event);
   event->type = B_LENDIAN_TO_HOST_INT32(event->type);

   return 0;
}


int FixMDLPivot(mstudiopivot_t *pivot)
{
   FixVec3(pivot->org);
   pivot->start = B_LENDIAN_TO_HOST_INT32(pivot->start);
   pivot->end = B_LENDIAN_TO_HOST_INT32(pivot->end);

   return 0;
}


int FixMDLAttachment(mstudioattachment_t *attachment)
{
   PSTR(attachment->name);

   attachment->type = B_LENDIAN_TO_HOST_INT32(attachment->type);
   attachment->bone = B_LENDIAN_TO_HOST_INT32(attachment->bone);
   FixVec3(attachment->org);

   for (int i=0; i<3; i++)
      FixVec3(attachment->vectors[i]);

   return 0;
}


int FixMDLAnim(studiohdr_t *hdr)
{
   mstudioseqdesc_t *seqdesc;
   seqdesc = (mstudioseqdesc_t *)((char *)hdr + hdr->seqindex);

   mstudioseqgroup_t *seqgroup;
   seqgroup = (mstudioseqgroup_t *)((char *)hdr + hdr->seqgroupindex) + seqdesc->seqgroup;

   short *value = (short *)((char *)hdr + seqgroup->data + seqdesc->animindex);

   int i, j;
   
   for(i=seqgroup->data+seqdesc->animindex, j=0; 
       i<hdr->seqindex; 
       i+=sizeof(short), j++) {
      value[j] = B_LENDIAN_TO_HOST_INT16(value[j]);
   }

   return 0;
}


int FixMDLBodyParts(studiohdr_t *hdr, mstudiobodyparts_t *bodyparts)
{
   PSTR(bodyparts->name);

   bodyparts->nummodels = B_LENDIAN_TO_HOST_INT32(bodyparts->nummodels);
   PINT(bodyparts->nummodels);
   bodyparts->base = B_LENDIAN_TO_HOST_INT32(bodyparts->base);
   PINT(bodyparts->base);
   bodyparts->modelindex = B_LENDIAN_TO_HOST_INT32(bodyparts->modelindex);
   PINT(bodyparts->modelindex);

   mstudiomodel_t *model;
   model = (mstudiomodel_t *)((char *)hdr + bodyparts->modelindex);
   for (int i=0; i<bodyparts->nummodels; i++, model++)
      FixMDLModel(hdr, model);

   return 0;
}


int FixMDLTexture(mstudiotexture_t *texture)
{
   PSTR(texture->name);

   texture->flags = B_LENDIAN_TO_HOST_INT32(texture->flags);
   texture->width = B_LENDIAN_TO_HOST_INT32(texture->width);
   texture->height = B_LENDIAN_TO_HOST_INT32(texture->height);
   texture->index = B_LENDIAN_TO_HOST_INT32(texture->index);
   
   PINT(texture->index);

   return 0;
}


int FixMDLModel(studiohdr_t *hdr, mstudiomodel_t *model)
{
   PSTR(model->name);

   model->type = B_LENDIAN_TO_HOST_INT32(model->type);
   model->boundingradius = B_LENDIAN_TO_HOST_FLOAT(model->boundingradius);

   model->nummesh = B_LENDIAN_TO_HOST_INT32(model->nummesh);
   PINT(model->nummesh);
   model->meshindex = B_LENDIAN_TO_HOST_INT32(model->meshindex);
   PINT(model->meshindex);

   model->numverts = B_LENDIAN_TO_HOST_INT32(model->numverts);
   PINT(model->numverts);
   model->vertinfoindex = B_LENDIAN_TO_HOST_INT32(model->vertinfoindex);
   PINT(model->vertinfoindex);
   model->vertindex = B_LENDIAN_TO_HOST_INT32(model->vertindex);
   PINT(model->vertindex);

   model->numnorms = B_LENDIAN_TO_HOST_INT32(model->numnorms);
   PINT(model->numnorms);
   model->norminfoindex = B_LENDIAN_TO_HOST_INT32(model->norminfoindex);
   PINT(model->norminfoindex);
   model->normindex = B_LENDIAN_TO_HOST_INT32(model->normindex);
   PINT(model->normindex);

   model->numgroups = B_LENDIAN_TO_HOST_INT32(model->numgroups);
   PINT(model->numgroups);
   model->groupindex = B_LENDIAN_TO_HOST_INT32(model->groupindex);
   PINT(model->groupindex);

   int i;

   mstudiomesh_t *mesh;
   mesh = (mstudiomesh_t *)((char *)hdr + model->meshindex);
   for (i=0; i<model->nummesh; i++, mesh++)
      FixMDLMesh(hdr, mesh);

   vec3_t *vert;
   vert = (vec3_t *)((char *)hdr + model->vertindex);
   for (i=0; i<model->numverts; i++)
      FixVec3(vert[i]);

   vec3_t *norm;
   norm = (vec3_t *)((char *)hdr + model->normindex);
   for (i=0; i<model->numnorms; i++)
      FixVec3(norm[i]);

   return 0;
}


int FixMDLMesh(studiohdr_t *hdr, mstudiomesh_t *mesh)
{
   mesh->numtris = B_LENDIAN_TO_HOST_INT32(mesh->numtris);
   PINT(mesh->numtris);
   mesh->triindex = B_LENDIAN_TO_HOST_INT32(mesh->triindex);
   PINT(mesh->triindex);

   mesh->skinref = B_LENDIAN_TO_HOST_INT32(mesh->skinref);

   mesh->numnorms = B_LENDIAN_TO_HOST_INT32(mesh->numnorms);
   PINT(mesh->numnorms);
   mesh->normindex = B_LENDIAN_TO_HOST_INT32(mesh->normindex);
   PINT(mesh->normindex);

   short *tricmds;
   tricmds = (short *)((char *)hdr + mesh->triindex);
   while (B_LENDIAN_TO_HOST_INT16(*(tricmds++))) {
      tricmds[-1] = B_LENDIAN_TO_HOST_INT16(tricmds[-1]);

      short i = tricmds[-1];

      if (i < 0) i = -i;

      for (; i > 0; i--, tricmds += 4) {
	 tricmds[0] = B_LENDIAN_TO_HOST_INT16(tricmds[0]);
	 tricmds[1] = B_LENDIAN_TO_HOST_INT16(tricmds[1]);
	 tricmds[2] = B_LENDIAN_TO_HOST_INT16(tricmds[2]);
	 tricmds[3] = B_LENDIAN_TO_HOST_INT16(tricmds[3]);
      }
   }
   
   return 0;
}


int FixMDLIfBigEndian(void *mdl)
{
   // At this point we have a buffer filled with little endian data.

   studiohdr_t *hdr;
   hdr = (studiohdr_t *)mdl;

   if (strncmp((const char *)hdr, "IDST", 4) &&
       strncmp((const char *)hdr, "IDSQ", 4)) return 0;

   FixMDLHdr(hdr); 

   int i;

   mstudiobone_t *bone;
   bone = (mstudiobone_t *)((char *)hdr + hdr->boneindex);
   for (i=0; i<hdr->numbones; i++, bone++)
      FixMDLBone(bone);
   
   mstudiobonecontroller_t *bonecontroller;
   bonecontroller = (mstudiobonecontroller_t *)((char *)hdr + hdr->bonecontrollerindex);
   for (i=0; i<hdr->numbonecontrollers; i++, bonecontroller++)
      FixMDLBoneController(bonecontroller);
   
   mstudiobbox_t *bbox;
   bbox = (mstudiobbox_t *)((char *)hdr + hdr->hitboxindex);
   for (i=0; i<hdr->numhitboxes; i++, bbox++)
      FixMDLBBox(bbox);

   // The sequence groups must be fixed before the sequence
   // descriptions.
   mstudioseqgroup_t *seqgroup;
   seqgroup = (mstudioseqgroup_t *)((char *)hdr + hdr->seqgroupindex);
   for (i=0; i<hdr->numseqgroups; i++, seqgroup++)
      FixMDLSeqGroup(seqgroup);

   mstudioseqdesc_t *seqdesc;
   seqdesc = (mstudioseqdesc_t *)((char *)hdr + hdr->seqindex);
   for (i=0; i<hdr->numseq; i++, seqdesc++)
      FixMDLSeqDesc(hdr, seqdesc);

   FixMDLAnim(hdr);
   
   mstudiotexture_t *texture;
   texture = (mstudiotexture_t *)((char *)hdr + hdr->textureindex);
   for (i=0; i<hdr->numtextures; i++, texture++)
      FixMDLTexture(texture);

   short *skinref;
   skinref = (short *)((char *)hdr + hdr->skinindex);
   for (i=0; i<(hdr->numskinfamilies * hdr->numskinref); i++)
      skinref[i] = B_LENDIAN_TO_HOST_INT16(skinref[i]);

   mstudioattachment_t *attachment;
   attachment = (mstudioattachment_t *)((char *)hdr + hdr->attachmentindex);
   for (i=0; i<hdr->numattachments; i++, attachment++)
      FixMDLAttachment(attachment);
   
   mstudiobodyparts_t *bodyparts;
   bodyparts = (mstudiobodyparts_t *)((char *)hdr + hdr->bodypartindex);
   for (i=0; i<hdr->numbodyparts; i++, bodyparts++)
      FixMDLBodyParts(hdr, bodyparts);
      
   //int *xnode;
   //xnode = (int *)((char *)hdr + hdr->transitionindex);
   //for (i=0; i<(hdr->numtransitions * hdr->numtransitions); i++)
   //   xnode[i] = B_LENDIAN_TO_HOST_INT32(xnode[i]);

   return 1;
}
