/* BeOS driver for Ghostscript using a BBitmap for buffering.
 * This driver has been heavily rewritten from the previous version.
 *
 * Copyright 1998, Jake Hamby
 * Send all comments, bug fixes, etc. to:  jehamby@lightside.com
 * 
 * Anti-Aliasing drivers: bealpha2, bealpht2, bealpha4 and bealpht4 
 * Copyright 2000, Michael Pfeiffer
 */

/* When BE_ALPHA_BITMAP_CACHE is defined a limited bitmap cache
   is used 
 */
#define BE_ALPHA_BITMAP_CACHE
/* Size of the hashtable */
#define BE_ALPHA_HASHTABLE_SIZE 255
/* Max number of bitmaps in cache */
#define BE_ALPHA_MAX_BITMAPS 500
/* On overflow remove this number of bitmaps */
#define BE_ALPHA_REMOVE_BITMAPS 100 
/* Max size */
/* 4 MBytes (divide by 4, because bitmaps have 4 bytes per pixel) */
#define BE_ALPHA_MAX_SIZE 4*1024*1024/4 

/* When BE_ALPHA_BITMAP_CACHE is NOT defined 
 * BE_ALPHA_CACHE_ENABLED can have the values
 * 1 ... ALL bitmaps are cached (this is dangerous and can crash!!!)
 * 0 ... no bitmap is cached (this is safe and slow)
 */ 
#define BE_ALPHA_CACHE_ENABLED 0


struct bmapcache_s;   /* Contains a BBitmap, so can't define from C */
struct bmap_alpha_cache_s;

/* Define the BeOS device */
typedef struct gx_device_be_s {
	gx_device_common;
	sem_id mutex;		/* for gsdll_lock_device */
	BBitmap *m_bitmap; /* BBitmap for buffering */
	BView *m_view;     /* offscreen view for drawing */
	struct bmapcache_s *bmapcache, **bmapcache_current;
#ifdef BE_ALPHA_BITMAP_CACHE
	struct bmap_alpha_cache_s *alpha_hashtable[BE_ALPHA_HASHTABLE_SIZE];
	/* Most recently used list; 
	 * used to delete the least recently used bitmaps */	
	struct bmap_alpha_cache_s *alpha_mru_first, *alpha_mru_last;
	/* List of temporary bitmaps (id = gx_no_bitmap_id ) */
	struct bmap_alpha_cache_s *alpha_tmp_list;
	int alpha_num_bmaps;
	long alpha_size;
#endif
#ifdef PROFILE
	int fillrect, copymono, drawline, copyalpha;
	long size, bitmaps;
#endif
} gx_device_be;

/* Default dots-per-inch (be sure to choose an even number!) */
#define INITIAL_RESOLUTION 96.0
#define INITIAL_WIDTH (INITIAL_RESOLUTION * 85 / 10 + 1)
#define INITIAL_HEIGHT (INITIAL_RESOLUTION * 11 + 1)
