#    Copyright (C) 1990, 1995, 1996, 1997, 1998 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# $Id: beostail.mak,v 1.9 1998/11/25 17:38:49 jehamby Exp $
# This is the last part of the makefile for BeOS.

# Define the name of this makefile.
UNIXTAIL_MAK=$(GLSRC)beostail.mak

# The following prevents GNU make from constructing argument lists that
# include all environment variables, which can easily be longer than
# brain-damaged system V allows.

.NOEXPORT:

# -------------------------------- Library -------------------------------- #

## The Unix platforms

# We have to include a test for the existence of sys/time.h,
# because some System V platforms don't have it.

# Define pipes as a separable feature.

pipe_=$(GLOBJ)gdevpipe.$(OBJ)
pipe.dev: $(UNIXTAIL_MAK) $(ECHOGS_XE) $(pipe_)
	$(SETMOD) pipe $(pipe_)
	$(ADDMOD) pipe -iodev pipe

$(GLOBJ)gdevpipe.$(OBJ): $(GLSRC)gdevpipe.c $(AK) $(errno__h) $(pipe__h) $(stdio__h) $(string__h) \
  $(gserror_h) $(gsmemory_h) $(gstypes_h) $(gxiodev_h) $(stream_h)
	$(GLCC) $(GLO_)gdevpipe.$(OBJ) $(C_) $(GLSRC)gdevpipe.c

# BeOS platform
beos__=$(GLOBJ)gp_getnv.$(OBJ) $(GLOBJ)gp_nofb.$(OBJ) $(GLOBJ)gp_beos.$(OBJ) $(GLOBJ)gp_unifs.$(OBJ) $(GLOBJ)gp_unifn.$(OBJ)
beos_.dev: $(beos__) nosync.dev
	$(SETMOD) beos_ $(beos__) -include nosync
# Using a file device resource to get the console streams re-initialized
# is bad architecture (an upward reference to ziodev),
# but it will have to do for the moment.
#   We need to redirect stdin/out/err to gsdll_callback
	$(ADDMOD) beos_ -iodev wstdio

bealpha2__=$(GLOBJ)gp_getnv.$(OBJ) $(GLOBJ)gp_nofb.$(OBJ) $(GLOBJ)gp_beos.$(OBJ) $(GLOBJ)gp_unifs.$(OBJ) $(GLOBJ)gp_unifn.$(OBJ)
bealpha2_.dev: $(bealpha2__) nosync.dev
	$(SETMOD) bealpha2_ $(bealpha2__) -include nosync
	$(ADDMOD) bealpha2_ -iodev wstdio

bealpha4__=$(GLOBJ)gp_getnv.$(OBJ) $(GLOBJ)gp_nofb.$(OBJ) $(GLOBJ)gp_beos.$(OBJ) $(GLOBJ)gp_unifs.$(OBJ) $(GLOBJ)gp_unifn.$(OBJ)
bealpha4_.dev: $(bealpha4__) nosync.dev
	$(SETMOD) bealpha4_ $(bealpha4__) -include nosync
	$(ADDMOD) bealpha4_ -iodev wstdio

bealpht2__=$(GLOBJ)gp_getnv.$(OBJ) $(GLOBJ)gp_nofb.$(OBJ) $(GLOBJ)gp_beos.$(OBJ) $(GLOBJ)gp_unifs.$(OBJ) $(GLOBJ)gp_unifn.$(OBJ)
bealpht2_.dev: $(bealpht2__) nosync.dev
	$(SETMOD) bealpht2_ $(bealpht2__) -include nosync
	$(ADDMOD) bealpht2_ -iodev wstdio

bealpht4__=$(GLOBJ)gp_getnv.$(OBJ) $(GLOBJ)gp_nofb.$(OBJ) $(GLOBJ)gp_beos.$(OBJ) $(GLOBJ)gp_unifs.$(OBJ) $(GLOBJ)gp_unifn.$(OBJ)
bealpht4_.dev: $(bealpht4__) nosync.dev
	$(SETMOD) bealpht4_ $(bealpht4__) -include nosync
	$(ADDMOD) bealpht4_ -iodev wstdio

$(GLOBJ)gp_beos.$(OBJ): $(GLSRC)gp_beos.c $(AK)\
 $(pipe__h) $(string__h) $(time__h)\
 $(gx_h) $(gsexit_h) $(gp_h)
	$(GLCC) $(GLO_)gp_beos.$(OBJ) $(C_) $(GLSRC)gp_beos.c

# -------------------------- Auxiliary programs --------------------------- #

$(GENINIT_XE): $(GLSRC)geninit.c $(AK) $(stdio__h) $(string__h)
	$(CCAUX) $(O_)$(GENINIT_XE) $(GLSRC)geninit.c

$(ANSI2KNR_XE): $(GLSRC)ansi2knr.c
	$(CCA2K) $(O_)$(ANSI2KNR_XE) $(GLSRC)ansi2knr.c

$(ECHOGS_XE): $(GLSRC)echogs.c $(AK)
	$(CCAUX) $(O_)$(ECHOGS_XE) $(GLSRC)echogs.c

# On the RS/6000 (at least), compiling genarch.c with gcc with -O
# produces a buggy executable.
$(GENARCH_XE): $(GLSRC)genarch.c $(AK) $(stdpre_h)
	$(CCAUX) $(O_)$(GENARCH_XE) $(GLSRC)genarch.c

$(GENCONF_XE): $(GLSRC)genconf.c $(AK) $(stdpre_h)
	$(CCAUX) $(O_)$(GENCONF_XE) $(GLSRC)genconf.c

$(GENDEV_XE): $(GLSRC)gendev.c $(AK) $(stdpre_h)
	$(CCAUX) $(O_)$(GENDEV_XE) $(GLSRC)gendev.c

# Query the environment to construct gconfig_.h.
# The "else true; is required because Ultrix's implementation of sh -e
# terminates execution of a command if any error occurs, even if the command
# traps the error with ||.
INCLUDE=/boot/develop/headers/posix
$(gconfig__h): $(UNIXTAIL_MAK) $(ECHOGS_XE)
	$(ECHOGS_XE) -w $(gconfig__h) -x 2f2a -s This file was generated automatically. -s -x 2a2f
	if ( test -f $(INCLUDE)/dirent.h ); then $(ECHOGS_XE) -a $(gconfig__h) -x 23 define HAVE_DIRENT_H; else true; fi
	if ( test -f $(INCLUDE)/ndir.h ); then $(ECHOGS_XE) -a $(gconfig__h) -x 23 define HAVE_NDIR_H; else true; fi
	if ( test -f $(INCLUDE)/sys/dir.h ); then $(ECHOGS_XE) -a $(gconfig__h) -x 23 define HAVE_SYS_DIR_H; else true; fi
	if ( test -f $(INCLUDE)/sys/ndir.h ); then $(ECHOGS_XE) -a $(gconfig__h) -x 23 define HAVE_SYS_NDIR_H; else true; fi
	if ( test -f $(INCLUDE)/sys/time.h ); then $(ECHOGS_XE) -a $(gconfig__h) -x 23 define HAVE_SYS_TIME_H; else true; fi
	if ( test -f $(INCLUDE)/sys/times.h ); then $(ECHOGS_XE) -a $(gconfig__h) -x 23 define HAVE_SYS_TIMES_H; else true; fi

# ----------------------------- Main program ------------------------------ #

### Library files and archive

LIB_ARCHIVE_ALL=$(LIB_ALL) $(DEVS_ALL)\
 $(GLOBJ)gsnogc.$(OBJ) $(GLOBJ)gconfig.$(OBJ) $(GLOBJ)gscdefs.$(OBJ)

# Build an archive for the library only.
# This is not used in a standard build.
GSLIB_A=$(GS)lib.a
$(GSLIB_A): $(LIB_ARCHIVE_ALL)
	rm -f $(GSLIB_A)
	$(AR) $(ARFLAGS) $(GSLIB_A) $(LIB_ARCHIVE_ALL)
	$(RANLIB) $(GSLIB_A)

### Interpreter main program

INT_ARCHIVE_ALL=$(PSOBJ)imainarg.$(OBJ) $(PSOBJ)imain.$(OBJ) $(INT_ALL) $(DEVS_ALL)\
 $(GLOBJ)gconfig.$(OBJ) $(GLOBJ)gscdefs.$(OBJ) $(GLOBJ)gsdll.$(OBJ)
XE_ALL=$(PSOBJ)gs.$(OBJ) $(INT_ARCHIVE_ALL)

# Build targets for BeOS objects.

$(GLOBJ)gsdll.$(OBJ): $(GLSRC)gsdll.c $(GLSRC)gsdll.h $(ghost_h)
	$(GLCC) $(GLO_)gsdll.$(OBJ) $(C_) $(GLSRC)gsdll.c

$(GLOBJ)gsfront.$(OBJ): $(GLSRC)gsfront.cpp $(GLSRC)gsdll.h
	$(GLCC) $(GLO_)gsfront.$(OBJ) $(C_) $(GLSRC)gsfront.cpp

# Build a library archive for the entire interpreter.
# This is used to build a BeOS shared library.
GS_A=$(GLOBJ)lib$(GS).so
ldt_tr=$(PSOBJ)ldt.tr
$(GS_A): $(AK) $(ECHOGS_XE) $(INT_ARCHIVE_ALL)
	mkdir -p $(GLOBJ)lib
	ln -sf ../../$(JSRCDIR)/libjpeg.so $(GLOBJ)lib/libjpeg.so
	ln -sf ../../$(PSRCDIR)/libpng.so $(GLOBJ)lib/libpng.so
	ln -sf ../../$(ZSRCDIR)/libz.so $(GLOBJ)lib/libz.so
	rm -f $(GS_A)
	$(ECHOGS_XE) -w $(ldt_tr) -n - $(CCLD) $(LDFLAGS) $(XLIBDIRS) -o $(GS_A)
	$(ECHOGS_XE) -a $(ldt_tr) -n -s $(GLOBJ)gsdll.$(OBJ) -s
	cat $(ld_tr) >>$(ldt_tr)
	$(ECHOGS_XE) -a $(ldt_tr) -s - $(EXTRALIBS)
	$(SH) <$(ldt_tr)

# Here is the final link step.
$(GS_XE): $(AK) $(GLOBJ)gsfront.$(OBJ) $(GS_A)
	ln -sf ../libgs.so $(GLOBJ)lib/libgs.so
	$(CCLD) -o $(GS_XE) $(GLOBJ)gsfront.$(OBJ) -L$(GLOBJ)lib -lgs -lbe
