#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <Errors.h>
#include <kernel/fs_attr.h>
#include <sys/types.h>
#include <errno.h>

int main(int argc,char **argv)
{
	if(argc<3) {
		fprintf(stderr,"usage : %s attr_name src_file\n",argv[0]);
		exit(1);
	}
	
	attr_info info; 
	int fd; 
	char *buffer; 
	ssize_t nread;
	
	fd = open(argv[2],O_RDONLY);
	if (fd) {
		if(0 == fs_stat_attr(fd, argv[1], &info)) {
			buffer = (char *) malloc((size_t) info.size);
			if (buffer) {
				nread = fs_read_attr(fd, argv[1], info.type, 0, buffer,
					info.size);
				if(nread >= 0) {
					if(nread != info.size)
						fprintf(stderr,"warning: %d bytes instead of %d"
							"were read.\n",nread,info.size);
					write(STDOUT_FILENO,buffer,nread);
					close(fd);
					exit(0);
				}
				else {
					perror("fs_read_attr");
					exit(1);
				}
			}
			else {
				fprintf(stderr,"fatal:not enough memory !\n");
				exit(1);
			}
		}
		else {
			// give a more meaningful message for B_ENTRY_NOT_FOUND
			if(errno == B_ENTRY_NOT_FOUND)
				fprintf(stderr,"%s: attribute not found\n",argv[1]);
			else
				perror("fs_stat_attr");
			exit(1);
		}
	}
	else {
		perror("open");
		exit(0);
	}
	
	// we shouldn't get there
	
	fprintf(stderr,"%s error: this can't happen.\n",argv[0]);
	return 1;
}
