#include <Application.h>
#include <Window.h>
#include <View.h>
#include <ScrollView.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <Screen.h>
#include <Bitmap.h>
#include <string.h>
#include <stdlib.h>


extern "C" 
void ShowImage(unsigned char _map[3][256], unsigned char *image, long xdim, long ydim);


static const char *APP_SIG="application/x-vnd.dungan.drawmap";

unsigned char map[3][256];
unsigned char *raw_image = NULL;

long xsize = 0;
long ysize = 0;

BBitmap *bitmap_image = NULL;


class BeAppWindow : public BWindow {
public:
   BeAppWindow(BRect frame);
   virtual void MessageReceived(BMessage *message);
   virtual bool QuitRequested(void);
};


class MyMainView : public BView {
public:
   MyMainView(BRect frame) : BView(frame, "main_view", 
				   B_FOLLOW_ALL_SIDES, B_WILL_DRAW) {
      bitmap_image = new BBitmap(BRect(0,0,xsize,ysize), B_RGB32);
      uchar *bits = (uchar *)bitmap_image->Bits();
      
      for (int i = 0; i < ysize; i++)  {
	 for (int j = 0; j < xsize; j++) {
	    int color = raw_image[i*xsize + j];
	    bits[i*xsize*4 + j*4 + 0] = map[0][color];
	    bits[i*xsize*4 + j*4 + 1] = map[1][color];
	    bits[i*xsize*4 + j*4 + 2] = map[2][color];
	 }
      }
   }
   virtual void Draw(BRect updateRect);
};


class BeApp : public BApplication {
   BeAppWindow *window;
public:
   BeApp(void) : BApplication(APP_SIG) {}
   virtual void ReadyToRun(void);
};


// BeAppWindow Methods

BeAppWindow::BeAppWindow(BRect frame) :
   BWindow(frame, "Drawmap", B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{
   BMenuBar *menubar;
   BMenu *menu;
   BMenuItem *menu_item;

   menubar = new BMenuBar(BRect(0,0,0,0), "menu_bar");

   menu = new BMenu("File");
   menubar->AddItem(menu);
	
   menu_item = new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED));
   menu->AddItem(menu_item);

   AddChild(menubar);

   BRect main_view_frame = Bounds();
   main_view_frame.top += menubar->Bounds().Height()+1;

   main_view_frame.bottom -= B_H_SCROLL_BAR_HEIGHT;
   main_view_frame.right -= B_V_SCROLL_BAR_WIDTH;

   MyMainView *view = new MyMainView(main_view_frame);

   BScrollView *scroll_view = new BScrollView("scroll_view", view,
					      B_FOLLOW_ALL, 0, true, true);

   BScrollBar *scroll_bar;
   scroll_bar = scroll_view->ScrollBar(B_HORIZONTAL);
   if (xsize-main_view_frame.Width() > 0) { 
      scroll_bar->SetRange(0, xsize-main_view_frame.Width());
      scroll_bar->SetProportion(1.0 - ((xsize-main_view_frame.Width())/xsize));
   } else {
      scroll_bar->SetRange(0, 0);
      scroll_bar->SetProportion(1.0);
   }

   scroll_bar = scroll_view->ScrollBar(B_VERTICAL);
   if (ysize-main_view_frame.Height() > 0) {
      scroll_bar->SetRange(0, ysize-main_view_frame.Height());
      scroll_bar->SetProportion(1.0 - ((ysize-main_view_frame.Height())/ysize));
   } else {
      scroll_bar->SetRange(0, 0);
      scroll_bar->SetProportion(1.0);
   }

   AddChild(scroll_view);
}


bool BeAppWindow::QuitRequested(void)
{
   be_app->PostMessage(B_QUIT_REQUESTED);
   return true;
}


void BeAppWindow::MessageReceived(BMessage *message)
{
   switch(message->what) {
   }
}


// MyMainView Methods

void MyMainView::Draw(BRect updateRect)
{
   BView::Draw(updateRect);
   BView::DrawBitmap(bitmap_image);
}


// BeApp Methods

void BeApp::ReadyToRun(void)
{
   int xdim;
   int ydim;

   BRect screen_frame = BScreen(B_MAIN_SCREEN_ID).Frame();

   xdim = (int) (screen_frame.right - screen_frame.left - (2 * B_V_SCROLL_BAR_WIDTH));
   ydim = (int) (screen_frame.bottom - screen_frame.top - (2 * B_H_SCROLL_BAR_HEIGHT));

   // We want to make the window as big as possible, yet still
   // smaller than the screen's dimentions.
   if (xdim > xsize) xdim = (int)(xsize + B_V_SCROLL_BAR_WIDTH);
   if (ydim > ysize) ydim = (int)(ysize + (3 * B_H_SCROLL_BAR_HEIGHT));

   int left = (int)((screen_frame.right - xdim) / 2);
   int top = (int)((screen_frame.bottom - ydim) / 2);
	
   BRect window_frame(left, top, left+xdim, top+ydim);

   window = new BeAppWindow(window_frame);
   window->Show();
}


void ShowImage(unsigned char _map[3][256], unsigned char *image, long xdim, long ydim)
{
   memcpy(map, _map, 3*256);
   raw_image = image;
   xsize = abs(xdim);
   ysize = abs(ydim);
	
   BeApp *app = new BeApp();
   app->Run();
   delete app;
}
