// NodeInspector.h
// * PURPOSE
//   UI component (view) providing access to a selected
//   NodeRef's properties.
// * HISTORY
//   e.moon		24aug99		Begun.

#ifndef __NodeInspector_H__
#define __NodeInspector_H__

#include <list>

#include <View.h>

class BButton;
class BCheckBox;
class BStringView;
class BTextControl;
class BMenuField;
class BMenu;

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class NodeManager;
class NodeRef;

class InspectorToggleButton;
class NumericValControl;

class _NodeInfoView;

class NodeInspector :
	public	BView {
	typedef	BView _inherited;

public:											// *** messages
	enum message_t {
		// nodeID: int32
		M_SELECT_NODE						= NodeInspector_message_base,

		// sent when lock button's state changes
		M_TOGGLE_LOCK,
		M_TOGGLE_PARAMETERS,
		
		// triggers run-mode selection
		M_SET_NODE_RUN_MODE,
		
		// toggle cycle
		// [e.moon 12oct99]
		M_TOGGLE_
	};
	
public:											// *** ctors/dtor
	virtual ~NodeInspector(); //nyi
	
	NodeInspector(
		NodeManager*						nodeManager,
		const char*							name); //nyi

public:											// *** accessors

	bool canAcceptNewTarget() const;

	// +++++ need to be able to query & set the lock & parameter toggles

public:											// *** BView
	virtual void AttachedToWindow();
	virtual void AllAttached();
	virtual void AllDetached();
	virtual void Draw(
		BRect										updateRect);
	virtual void FrameResized(
		float										width,
		float										height);
		
public:											// *** BHandler
	virtual void MessageReceived(
		BMessage*								message);
		
private:										// *** BHandler impl.
	void _handleSelectNode(
		BMessage*								message);
		
protected:									// *** internal operations

	// select the given group; initialize controls
	// (if 0, gray out all controls)
	void _selectNode(
		uint32									nodeID);

	void _observeNode();
	void _releaseNode();

protected:									// *** controls

	void _constructControls();
	
	void _disableControls();
	void _enableControls();

	void _updateTransportButtons();
	void _updateRunMode();
	
	void _populateRunModeMenu(
		BMenu*									menu);
		
	// add the given invoker to be retargeted to this
	// view (used for controls whose messages need a bit more
	// processing before being forwarded to the NodeGroup.)
	void _addLocalTarget(
		BInvoker*								invoker);

	// add the given invoker to be targeted to the NodeRef
	void _addNodeRefTarget(
		BInvoker*								invoker);

protected:									// *** layout

	void _initLayout();
	void _updateLayout(
		bool										asSingleTransaction=true);

//	void _toggleControlView();
	void _showControlView();
	void _hideControlView();

private:
	friend _NodeInfoView;

	// logical
	NodeManager*							m_manager;
	NodeRef*									m_ref;

	bool											m_lockTarget;
	bool											m_gotFirstTarget;
	
	// controls
	_NodeInfoView*						m_infoView;
	BMenuField*								m_runModeView;

	BCheckBox*								m_cycleCheckBox;
	BButton*									m_prerollButton;
	
	InspectorToggleButton*		m_lockButton;
	InspectorToggleButton*		m_parametersButton;

	BView*										m_controlView;

	typedef list<BInvoker*>		target_set;
	target_set								m_localTargets;
	target_set								m_nodeTargets;
	
	// layout
	class _layout_state;
	_layout_state*						m_layout;
};

__END_CORTEX_NAMESPACE
#endif /*__NodeInspector_H__*/
