// InspectorToggleButton.h
// * PURPOSE
//   Indicate and control whether a given inspector view is
//   'locked' to a single target.  When disabled, the inspector
//   should follow the main routing view's selection.
// * HISTORY
//   e.moon		24aug99		Begun

#ifndef __InspectorToggleButton_H__
#define __InspectorToggleButton_H__

#include <Control.h>
#include <Messenger.h>


#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE


class InspectorToggleButton :
	public	BControl {
	typedef	BControl _inherited;
	
public:											// *** ctors/dtor
	virtual ~InspectorToggleButton();
	InspectorToggleButton(
		BRect										frame,
		const char*							name,
		const char*							label,
		BMessage*								message,
		uint32									resizingMode =B_FOLLOW_LEFT|B_FOLLOW_TOP,
		uint32									flags =B_WILL_DRAW|B_NAVIGABLE|B_FRAME_EVENTS);
		
public:											// *** BView
	virtual void Draw(
		BRect										updateRect);

	virtual void FrameResized(
		float										width,
		float										height);

	virtual void MouseDown(
		BPoint									point);
	virtual void MouseMoved(
		BPoint									point,
		uint32									transit,
		const BMessage*					message);
	virtual void MouseUp(
		BPoint									point);

public:											// *** BControl
	
	virtual void SetEnabled(
		bool										enabled);
		
private:										// implementation
	void _initColors();
	void _initLayout();
	void _updateLayout(
		float										width,
		float										height);

private:
	BFont											m_font;
	BRect											m_lastFrame;
	BPoint										m_labelPos;

	rgb_color									m_bgColor[2];
	rgb_color									m_hiColor[2];
	rgb_color									m_loColor[2];
	rgb_color									m_labelColor[2];
	
	bool											m_tracking;
	int32											m_nextValue;
};

__END_CORTEX_NAMESPACE
#endif /*__InspectorToggleButton_H__*/