// GridViewImpl.h
// e.moon 9mar99
//
// Implementation helpers for GridView.
//
// INTERFACES
//   IGrip
//     Interface for view which provide row/column drag info
//     to the GridView.
//
// CLASSES
//   RowGripView
//     A horizontal splitter implementation of IGrip
//   ColumnGripView
//     A vertical splitter implementation.

#ifndef __GridViewImpl_H__
#define __GridViewImpl_H__

#include "MouseTrackingHelpers.h"

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class IGrip {
public:			// types
	enum orientation_t {
		ROW,
		COLUMN
	};
	
public:			// interface
	virtual orientation_t gripOrientation() const=0;
	virtual uint32 gripTargetIndex() const=0;
};

// RowGripView

class RowGripView :
	public MouseTrackingSourceView,
	public IGrip {
	
public:					// ctor/dtor/accessors
	RowGripView(uint32 row, BRect frame);
	virtual ~RowGripView() {}

public:					// IGrip impl.
	virtual orientation_t gripOrientation() const {
		return ROW;
	}
	virtual uint32 gripTargetIndex() const {
		return m_row;
	}

public:					// BView impl.
	virtual void Draw(BRect updateRect);
	
protected:				// members
	uint32		m_row;
};

// ColumnGripView +++++

__END_CORTEX_NAMESPACE
#endif /* __GridViewImpl_H__ */