// GridColumn.h
// e.moon 5may99 (GridView layout manager)
//
// PURPOSE
//   Represents a single column of a grid-based layout
//   (contained cells are organized by row and column.)
//
// HISTORY
//   e.moon 5may99: adapted from previous GridView.h

#ifndef __GRIDCOLUMN_H__
#define __GRIDCOLUMN_H__

#include <SupportDefs.h>

#include "cortex_defs.h"
__BEGIN_CORTEX_NAMESPACE

class GridView;

// ---------------------------------------------------------------- //
// represents settings & state for a given column
// columns are given an initial width & an ID/type code (which must
// be unique across the GridView.)
// ---------------------------------------------------------------- //

class GridColumn {
	friend class GridView;

public:					// ctor/dtor/accessors
	virtual ~GridColumn();
	GridColumn(float width, int32 flags=0, void* pCookie=0);
	GridColumn(int32 id, float width, int32 flags=0, void* pCookie=0);

	int32 id() const { return m_id; }
	int32 flags() const { return m_flags; }
	void* cookie() const { return m_pCookie; }
	
	const float width() const { return m_width; }
	const float borderWidth() const { return m_borderWidth; }
	const float xOffset() const { return m_xOffset; }
	
private:				// members & icky internals
	int32				m_id;
	int32				m_flags;
	void*				m_pCookie;
	
	// width, border, & x offset maintained by the GridView
	float				m_width;
	float				m_borderWidth;
	float				m_xOffset;
	
private:				// internal operations
	float cellWidth() const { return m_width - m_borderWidth; }
	
private:				// static default-ID counter
	static uint32			s_defID;
	static uint32 nextID() { return s_defID++; }
};

__END_CORTEX_NAMESPACE
#endif /* __GRIDCOLUMN_H__ */
