//:  BeOSRadioButtonUI.java

package com.be.swing.plaf.beos;

import java.awt.*;

import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * BeOS Look and Feel TextAreaUI delegate.
 * Only necessary because the Basic TextAreaUI component
 * doesn't paint disabled text correctly.  
 *
 * @author  Michael Heuer
 * @version $Id: BeOSRadioButtonUI.java,v 1.3 1999/11/08 21:07:15 heuermh Exp $
 */
public class BeOSRadioButtonUI extends BasicRadioButtonUI {

	private static final BeOSRadioButtonUI radioButtonUI = new BeOSRadioButtonUI();

	private boolean defaultsInitialized;

	protected Color textColor;
	protected Color disabledTextColor;

	public static ComponentUI createUI(JComponent c) {
		return radioButtonUI;
	}

	public void installDefaults(AbstractButton b) {
		super.installDefaults(b);

		if (!defaultsInitialized) {

			textColor = UIManager.getColor(getPropertyPrefix() + "foreground");
			disabledTextColor = UIManager.getColor(getPropertyPrefix() + "disabledText");
		}
		defaultsInitialized = true;
	}

	protected Color getTextColor() {
		return textColor;
	}

	protected Color getDisabledTextColor() {
		return disabledTextColor;
	}


		// this code is only cut-n-pasted from the BasicRadioButtonUI source
		//    because Sun does not use the paintText method.  See bug #[not public yet]


	/* These Dimensions/Rectangles are allocated once for all 
	 * RadioButtonUI.paint() calls.  Re-using rectangles 
	 * rather than allocating them in each paint call substantially 
	 * reduced the time it took paint to run.  Obviously, this 
	 * method can't be re-entered.
	 */
	private static Dimension size = new Dimension();
	private static Rectangle viewRect = new Rectangle();
	private static Rectangle iconRect = new Rectangle();
	private static Rectangle textRect = new Rectangle();

	/**
	 * paint the radio button
	 */
	public synchronized void paint(Graphics g, JComponent c) {
		AbstractButton b = (AbstractButton) c;
		ButtonModel model = b.getModel();

		Font f = c.getFont();
		g.setFont(f);
		FontMetrics fm = g.getFontMetrics();

		size = b.getSize(size);
		viewRect.x = viewRect.y = 0;
		viewRect.width = size.width;
		viewRect.height = size.height;
		iconRect.x = iconRect.y = iconRect.width = iconRect.height = 0;
		textRect.x = textRect.y = textRect.width = textRect.height = 0;

		Icon altIcon = b.getIcon();
		Icon selectedIcon = null;
		Icon disabledIcon = null;

		String text = SwingUtilities.layoutCompoundLabel(
					c, fm, b.getText(), altIcon != null ? altIcon : getDefaultIcon(),
					b.getVerticalAlignment(), b.getHorizontalAlignment(),
					b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
					viewRect, iconRect, textRect, getDefaultTextIconGap(b));

		// fill background
		if(c.isOpaque()) {
			g.setColor(b.getBackground());
			g.fillRect(0,0, size.width, size.height); 
		}


		// Paint the radio button
		if(altIcon != null) { 

			if(!model.isEnabled()) {
				altIcon = b.getDisabledIcon();
			} else if(model.isPressed() && model.isArmed()) {
				altIcon = b.getPressedIcon();
				if(altIcon == null) {
					// Use selected icon
					altIcon = b.getSelectedIcon();
				} 
			} else if(model.isSelected()) {
				if(b.isRolloverEnabled() && model.isRollover()) {
					altIcon = (Icon) b.getRolloverSelectedIcon();
					if (altIcon == null) {
						altIcon = (Icon) b.getSelectedIcon();
					}
				} else {
					altIcon = (Icon) b.getSelectedIcon();
				}
			} else if(b.isRolloverEnabled() && model.isRollover()) {
				altIcon = (Icon) b.getRolloverIcon();
			} 

			if(altIcon == null) {
				altIcon = b.getIcon();
			}

			altIcon.paintIcon(c, g, iconRect.x, iconRect.y);

		} else {
			getDefaultIcon().paintIcon(c, g, iconRect.x, iconRect.y);
		}


		// Draw the Text
		if(text != null) {

			// this is what the paint method should be doing
			paintText(g, b, text, textRect.x, textRect.y + fm.getAscent());

			if(b.hasFocus() && b.isFocusPainted() && 
				textRect.width > 0 && textRect.height > 0 ) {
					paintFocus(g, textRect, size);
			}
		}
	}

	protected void paintText(Graphics g, JComponent c, String s, int textX, int textY) {

		AbstractButton ab = (AbstractButton) c;
		ButtonModel model = ab.getModel();

		int noMnemonic = -1;

		if (model.isEnabled()) {

			g.setColor(getTextColor());
			BasicGraphicsUtils.drawString(g, s, noMnemonic, textX, textY);
		} else {

			g.setColor(getDisabledTextColor());
			BasicGraphicsUtils.drawString(g, s, noMnemonic, textX, textY);
		}
	}
}