//:  BeOSPasswordFieldUI.java

package com.be.swing.plaf.beos;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * BeOS Look and Feel PasswordFieldUI delegate.
 * Only necessary because the Basic TextFieldUI component
 * does not repaint itself on focus changes.  
 *
 * @author  Michael Heuer
 * @version $Id: BeOSPasswordFieldUI.java,v 1.3 1999/11/08 21:07:14 heuermh Exp $
 */
public class BeOSPasswordFieldUI extends BasicTextFieldUI {
	private static final BeOSFocusListener focusListener = new BeOSFocusListener();

	public static ComponentUI createUI(JComponent c) {
		return new BeOSPasswordFieldUI();
	}

	protected void installListeners() {
		super.installListeners();

		getComponent().addFocusListener(focusListener);
	}

	protected void uninstallListeners() {
		super.uninstallListeners();
		
		getComponent().removeFocusListener(focusListener);
	}
}
        