//:  BeOSFocusListener.java

package com.be.swing.plaf.beos;

import java.awt.*;
import java.awt.event.*;

/**
 * Focus listener class that repaints the components
 * involved in the transfer of focus.  Necessary for
 * all the subclasses of TextComponentUI.
 *
 * @author  Michael Heuer
 * @version $Id: BeOSFocusListener.java,v 1.3 1999/11/08 21:07:12 heuermh Exp $
 */
public class BeOSFocusListener extends FocusAdapter {

	/**
	 * Repaints the component that gained focus.
	 */     
	public void focusGained(FocusEvent e) {
		
		Component c = (Component) e.getSource();
		c.repaint();
	}

	/**
	 * Repaints the component that lost focus.
	 */
	public void focusLost(FocusEvent e) {
		
		Component c = (Component) e.getSource();
		c.repaint();
	}       
}
