/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol.http;

import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;

public class HttpURLConnection
extends java.net.HttpURLConnection {
    private static final String[] headers = new String[]{"content-encoding", "content-length", "content-type", "content-location", "date", "expiration", "If-Modified-Since", "lastModified", "location", "server"};
    private static final int ContentEncoding = 0;
    private static final int ContentLength = 1;
    private static final int ContentType = 2;
    private static final int Date = 3;
    private static final int Expiration = 4;
    private static final int IfModifiedSince = 5;
    private static final int LastModified = 6;
    private static String proxyHost;
    private static int proxyPort;
    private static boolean useProxy;
    private String[] headersValue = new String[headers.length];
    private Socket sock;
    private InputStream in;
    private DataOutputStream out;
    private boolean redir = java.net.HttpURLConnection.getFollowRedirects();

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect() throws IOException {
        block2: while (true) {
            if (HttpURLConnection.useProxy) {
                var1_1 = HttpURLConnection.proxyPort;
                var2_2 = HttpURLConnection.proxyHost;
            } else {
                var1_1 = this.url.getPort();
                var2_2 = this.url.getHost();
            }
            if (var1_1 == -1) {
                var1_1 = 80;
            }
            this.sock = new Socket(var2_2, var1_1);
            this.in = new BufferedInputStream(this.sock.getInputStream());
            this.out = new DataOutputStream(this.sock.getOutputStream());
            if (HttpURLConnection.useProxy) {
                var3_3 = this.url.toString();
            } else {
                var3_3 = this.url.getFile();
                if (var3_3.equals("")) {
                    var3_3 = "/";
                }
            }
            this.out.writeBytes(this.method + " " + var3_3 + " HTTP/1.0\r\n\r\n");
            this.out.flush();
            var4_4 = new DataInputStream(this.in);
            while (true) {
                block13: {
                    if ((var5_5 = var4_4.readLine()) == null || var5_5.equals("")) break block13;
                    if (var5_5.startsWith("HTTP")) {
                        this.responseMessage = var5_5;
                        var6_6 = new StringTokenizer(var5_5);
                        if (var6_6.countTokens() < 3) continue;
                        var6_6.nextToken();
                        try {
                            this.responseCode = Integer.parseInt(var6_6.nextToken());
                        }
                        catch (NumberFormatException var7_9) {
                            this.responseCode = 500;
                        }
                        continue;
                    }
                    var6_7 = var5_5.indexOf(58);
                    if (var6_7 <= 0) continue;
                    var7_8 = var5_5.substring(0, var6_7);
                    ++var6_7;
                    if (true) ** GOTO lbl53
                }
                var5_5 = this.getHeaderField("location");
                if (this.redir == false) return;
                if (this.responseCode < 300) return;
                if (this.responseCode > 305) return;
                if (var5_5 == null) {
                    return;
                }
                this.url = new URL(var5_5);
                continue block2;
                do {
                    ++var6_7;
lbl53:
                    // 2 sources

                } while (Character.isWhitespace(var5_5.charAt(var6_7)));
                var8_10 = var5_5.substring(var6_7);
                this.setHeaderField(var7_8, var8_10);
            }
            break;
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public String getHeaderField(String string) {
        int n = 0;
        while (n < headers.length) {
            if (headers[n].equalsIgnoreCase(string)) {
                return this.getHeaderField(n);
            }
            ++n;
        }
        return null;
    }

    public String getHeaderField(int n) {
        if (n < 0 || n >= this.headersValue.length) {
            return null;
        }
        return this.headersValue[n];
    }

    public String getHeaderFieldKey(int n) {
        if (n < 0 || n >= headers.length) {
            return null;
        }
        return headers[n];
    }

    protected void setHeaderField(String string, String string2) {
        int n = 0;
        while (n < headers.length) {
            if (headers[n].equalsIgnoreCase(string)) {
                this.headersValue[n] = string2;
                break;
            }
            ++n;
        }
    }

    public Object getContent() throws IOException {
        if (this.headersValue[0] == null) {
            return this.in;
        }
        if (this.headersValue[0].startsWith("image/")) {
            return Toolkit.getDefaultToolkit().getImage(this.url).getSource();
        }
        return this.in;
    }

    protected void setContentTypeFromName() {
        String string;
        this.headersValue[2] = string = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
        this.headersValue[0] = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() {
        try {
            this.sock.close();
        }
        catch (IOException iOException) {
        }
        this.sock = null;
    }

    public boolean usingProxy() {
        return useProxy;
    }

    public void setInstanceFollowRedirects(boolean bl) {
        this.redir = bl;
    }

    public HttpURLConnection(URL uRL) {
        super(uRL);
    }

    static {
        proxyPort = -1;
        useProxy = false;
        proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null) {
            useProxy = true;
            String string = System.getProperty("http.proxyPort");
            if (string != null) {
                proxyPort = Integer.parseInt(string);
            }
        }
    }
}

