/*
 * Decompiled with CFR 0.152.
 */
package kaffe.management;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;

public class JIT
implements Runnable {
    private LineNumberReader reader;
    private boolean verbose;
    private ClassLoader loader;

    public static native void dumpActiveMethods(PrintStream var0, ClassLoader var1);

    public static void dumpActiveMethods(PrintStream printStream) {
        JIT.dumpActiveMethods(printStream, null);
    }

    public static native void translateMethod(String var0, String var1, String var2, ClassLoader var3);

    public static void translateMethod(String string, String string2, String string3) {
        JIT.translateMethod(string, string2, string3, null);
    }

    public static native void flushCache();

    public static void dumpActiveMethods(String string) throws IOException {
        PrintStream printStream = new PrintStream(new FileOutputStream(string));
        JIT.dumpActiveMethods(printStream);
        printStream.close();
    }

    public static void startPreloading(String string) throws IOException {
        JIT.startPreloading(string, false);
    }

    public static void startPreloading(String string, boolean bl) throws IOException {
        JIT.startPreloading(new FileInputStream(string), null, bl);
    }

    public static void startPreloading(InputStream inputStream, ClassLoader classLoader, boolean bl) throws IOException {
        Thread thread = new Thread(new JIT(inputStream, classLoader, bl));
        thread.setPriority(1);
        thread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread.currentThread().setName("JIT-Translator");
        try {
            String[] stringArray = new String[3];
            while (true) {
                int n = 0;
                while (true) {
                    if (n >= stringArray.length) {
                        if (this.verbose) {
                            System.err.println("translating " + stringArray[0] + "." + stringArray[1] + stringArray[2]);
                        }
                        try {
                            JIT.translateMethod(stringArray[0], stringArray[1], stringArray[2], this.loader);
                        }
                        catch (LinkageError linkageError) {
                            if (!this.verbose) break;
                            System.err.println("JIT-Translator: " + linkageError);
                        }
                        catch (Exception exception) {
                            if (!this.verbose) break;
                            System.err.println("JIT-Translator: " + exception);
                        }
                        break;
                    }
                    stringArray[n] = this.reader.readLine();
                    if (stringArray[n] == null) {
                        throw new Exception("reached end of file");
                    }
                    ++n;
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            if (this.verbose) {
                System.err.println("JIT-Translator: " + exception);
            }
            JIT.flushCache();
            if (this.verbose) {
                System.err.println("JIT-Translator done.");
            }
            return;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(stringArray[0])));
        JIT.dumpActiveMethods(printStream);
        System.exit(0);
    }

    private JIT(InputStream inputStream, ClassLoader classLoader, boolean bl) throws IOException {
        this.verbose = bl;
        this.loader = classLoader;
        this.reader = new LineNumberReader(new InputStreamReader(inputStream));
    }

    static {
        System.loadLibrary("management");
    }
}

