/*
 * Decompiled with CFR 0.152.
 */
package kaffe.applet;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import kaffe.applet.AppletTag;
import kaffe.applet.AudioPlayer;

public class AppletViewer
extends Frame
implements ActionListener,
WindowListener {
    public static boolean debug = false;
    static boolean showMenuBar = true;
    static boolean showStatusBar = true;
    private static Vector applets = new Vector();
    Label statusBar = new Label();
    Applet app;
    AppletTag tag;
    AppletContext context;
    private final String TagMenu = "Tag";
    private final String QuitMenu = "Quit";
    private final String StopMenu = "Stop";
    private final String StartMenu = "Start";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Applet createApplet(AppletTag appletTag, AppletStub appletStub) {
        Applet applet = null;
        try {
            String string = appletTag.getCodeTag();
            if (string == null) {
                System.out.println("didn't find code tag");
                System.exit(-1);
            }
            AppletClassLoader appletClassLoader = new AppletClassLoader(appletTag.getCodebaseURL(), appletTag.getArchiveTag());
            Class clazz = appletClassLoader.loadClass(string);
            applet = (Applet)clazz.newInstance();
            String string2 = appletTag.getName();
            if (string2 != null) {
                applet.setName(string2);
            }
            applet.setStub(appletStub);
            AppletContext appletContext = appletStub.getAppletContext();
            if (!(appletContext instanceof DefaultAppletContext)) return applet;
            ((DefaultAppletContext)appletContext).addApplet(applet);
            return applet;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return applet;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Quit".equals(string)) {
            if (this.app != null) {
                this.app.stop();
                this.app.destroy();
            }
            this.dispose();
        } else if ("Stop".equals(string)) {
            if (this.app != null) {
                this.app.stop();
            }
            this.context.showStatus("Applet stopped");
        } else if ("Start".equals(string)) {
            if (this.app != null) {
                this.app.start();
            }
            this.context.showStatus("Applet started");
        } else if ("Tag".equals(string)) {
            System.out.println("printing tags: ");
            System.out.println(this.tag);
            System.out.println(this.tag.getParameters());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n = -1;
        int n2 = -1;
        String string = null;
        showMenuBar = true;
        showStatusBar = true;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].startsWith("-d")) {
                debug = true;
            } else if (stringArray[n3].equals("-nomenu")) {
                showMenuBar = false;
            } else if (stringArray[n3].equals("-nostatus")) {
                showStatusBar = false;
            } else if (stringArray[n3].startsWith("-w")) {
                n = Integer.parseInt(stringArray[++n3]);
            } else if (stringArray[n3].startsWith("-h")) {
                n2 = Integer.parseInt(stringArray[++n3]);
            } else {
                string = stringArray[n3];
                break;
            }
            ++n3;
        }
        if (string == null) {
            System.out.println("Usage: AppletViewer [-debug] <url|file>");
            System.exit(0);
        }
        URLConnection uRLConnection = AppletViewer.openAppletURLConnection(string);
        URL uRL = uRLConnection.getURL();
        AppletTag[] appletTagArray = AppletTag.parseForApplets(uRLConnection.getInputStream());
        if (appletTagArray.length == 0) {
            System.err.println("Warning: no applets were found." + " Make sure the input contains an <applet> tag");
            System.exit(0);
        }
        int n4 = 0;
        while (n4 < appletTagArray.length) {
            AppletTag appletTag = appletTagArray[n4];
            appletTag.computeCodeBaseURL(uRL);
            if (debug) {
                System.out.println("AV: effective codebase= " + appletTag.getCodebaseURL());
            }
            if (n != -1) {
                appletTag.setAppletWidth(n);
            }
            if (n2 != -1) {
                appletTag.setAppletHeight(n2);
            }
            new AppletViewer(uRL, appletTag);
            ++n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URLConnection openAppletURLConnection(String string) throws IOException {
        URL uRL;
        try {
            if (!string.startsWith("http:") && !string.startsWith("file:")) {
                throw new MalformedURLException();
            }
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = string.startsWith(File.separator) ? new File(string).getCanonicalPath() : new File(System.getProperty("user.dir") + File.separator + string).getCanonicalPath();
            uRL = new URL("file", "", string2);
        }
        if (debug) {
            System.out.println("AV: reading from URL: " + uRL);
        }
        return uRL.openConnection();
    }

    void setMenus() {
        if (!showMenuBar) {
            return;
        }
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Applet");
        menu.add("Restart (dummy)");
        menu.add("Reload (dummy)");
        menu.add("Stop");
        menu.add("Save... (dummy)");
        menu.add("Start");
        menu.add("Clone... (dummy)");
        menu.addSeparator();
        menu.add("Tag");
        menu.add("Info... (dummy)");
        menu.add("Edit (dummy)");
        menu.add("Character Encoding (dummy)");
        menu.addSeparator();
        menu.add("Print... (dummy)");
        menu.addSeparator();
        menu.add("Properties... (dummy)");
        menu.addSeparator();
        menu.add("Close (dummy)");
        menu.add("Quit");
        menu.addActionListener(this);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.app != null) {
            this.app.stop();
            this.app.destroy();
        }
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public AppletViewer(URL uRL, AppletTag appletTag) throws IOException {
        super(appletTag.toString());
        this.setLayout(new BorderLayout());
        this.setMenus();
        this.statusBar.setFont(new Font("SansSerif", 1, 12));
        if (showStatusBar) {
            this.add("South", this.statusBar);
        }
        this.addWindowListener(this);
        this.tag = appletTag;
        DefaultAppletContext defaultAppletContext = new DefaultAppletContext(applets, this.statusBar);
        this.context = defaultAppletContext;
        DefaultAppletStub defaultAppletStub = new DefaultAppletStub(uRL, appletTag, this.context);
        this.app = AppletViewer.createApplet(this.tag, defaultAppletStub);
        if (this.app == null) {
            this.context.showStatus("Cannot start applet");
            return;
        }
        defaultAppletStub.add(this.app);
        this.add("Center", defaultAppletStub);
        this.addNotify();
        Dimension dimension = appletTag.getAppletSize();
        defaultAppletStub.appletResize(dimension.width, dimension.height);
        this.app.init();
        this.app.validate();
        this.app.start();
        this.pack();
        this.setVisible(true);
        if (debug) {
            System.out.println("my size " + this.getSize());
            System.out.println("stub size " + defaultAppletStub.getSize());
            System.out.println("label size " + this.statusBar.getSize());
        }
        this.context.showStatus("Applet started");
    }

    private static class AppletClassLoader
    extends URLClassLoader {
        AppletClassLoader(URL uRL, String string) throws IOException {
            super(new URL[0]);
            if (string.equals("")) {
                this.addURL(uRL);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
                while (stringTokenizer.hasMoreTokens()) {
                    this.addURL(new URL(uRL, stringTokenizer.nextToken()));
                }
            }
        }
    }

    public static class DefaultAppletContext
    implements AppletContext {
        private Vector apps = new Vector();
        Label statusBar;

        public void addApplet(Applet applet) {
            this.apps.addElement(applet);
        }

        public Applet getApplet(String string) {
            int n = 0;
            while (n < this.apps.size()) {
                Applet applet = (Applet)this.apps.elementAt(n);
                if (applet.getName().equals(string)) {
                    return applet;
                }
                ++n;
            }
            return null;
        }

        public Enumeration getApplets() {
            return this.apps.elements();
        }

        public AudioClip getAudioClip(URL uRL) {
            return new AudioPlayer(uRL);
        }

        public Image getImage(URL uRL) {
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }

        public void showDocument(URL uRL) {
            this.showDocument(uRL, "_self");
        }

        public void showDocument(URL uRL, String string) {
            System.err.println("Not implemented in AppletViewer:\n" + "showDocument(" + uRL + ", " + string + ")");
        }

        public void showStatus(String string) {
            this.statusBar.setText(" " + string + " ");
        }

        public DefaultAppletContext(Label label) {
            this(new Vector(), label);
        }

        public DefaultAppletContext(Vector vector, Label label) {
            this.statusBar = label;
            this.apps = vector;
        }
    }

    public static class DefaultAppletStub
    extends Panel
    implements AppletStub {
        AppletContext context;
        URL codebase;
        URL documentBase;
        Hashtable paramDict;
        Dimension preferredSize;

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        public AppletContext getAppletContext() {
            return this.context;
        }

        public URL getCodeBase() {
            return this.codebase;
        }

        public URL getDocumentBase() {
            return this.documentBase;
        }

        public String getParameter(String string) {
            if (this.paramDict == null) {
                return null;
            }
            String string2 = string.toLowerCase();
            String string3 = (String)this.paramDict.get(string2);
            if (debug) {
                System.out.println("AV: getP: " + string2 + " " + string3);
            }
            return string3;
        }

        public boolean isActive() {
            return true;
        }

        public void appletResize(int n, int n2) {
            this.preferredSize = new Dimension(n, n2);
            if (debug) {
                System.out.println("AV: resizing app to " + this.preferredSize);
            }
            this.setSize(n, n2);
        }

        public void doLayout() {
            super.doLayout();
            Component component = this.getComponent(0);
            if (component != null) {
                Dimension dimension = this.preferredSize;
                if (dimension == null) {
                    if (debug) {
                        System.out.println("AV: no pref size, using current size");
                    }
                    dimension = this.getSize();
                }
                if (debug) {
                    System.out.println("AV: setting child to " + dimension);
                    System.out.println("AV: my insets " + this.getInsets());
                }
                component.setBounds(0, 0, dimension.width, dimension.height);
            }
        }

        public DefaultAppletStub(URL uRL, AppletTag appletTag, AppletContext appletContext) {
            this.paramDict = appletTag.getParameters();
            this.context = appletContext;
            this.codebase = appletTag.getCodebaseURL();
            this.documentBase = uRL;
            this.setLayout(null);
        }
    }
}

