/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;

public class Timer {
    private final TimerThread thread = new TimerThread();

    public void schedule(TimerTask timerTask, long l) {
        this.scheduleDelay(timerTask, l, false, 0L, false);
    }

    public void schedule(TimerTask timerTask, Date date) {
        this.scheduleTime(timerTask, date.getTime(), false, 0L, false);
    }

    public void schedule(TimerTask timerTask, long l, long l2) {
        this.scheduleDelay(timerTask, l, true, l2, false);
    }

    public void schedule(TimerTask timerTask, Date date, long l) {
        this.scheduleTime(timerTask, date.getTime(), true, l, false);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long l, long l2) {
        this.scheduleDelay(timerTask, l, true, l2, true);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, Date date, long l) {
        this.scheduleTime(timerTask, date.getTime(), true, l, true);
    }

    public void scheduleDelay(TimerTask timerTask, long l, boolean bl, long l2, boolean bl2) {
        if (l < 0L) {
            throw new IllegalArgumentException("delay < 0");
        }
        this.scheduleTime(timerTask, System.currentTimeMillis() + l, bl, l2, bl2);
    }

    private void scheduleTime(TimerTask timerTask, long l, boolean bl, long l2, boolean bl2) {
        if (l < 0L) {
            throw new IllegalArgumentException("time < 0");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("period < 0");
        }
        this.thread.schedule(timerTask, this, l, bl ? l2 : -1L, bl2);
    }

    boolean unschedule(TimerTask timerTask) {
        return this.thread.unschedule(timerTask);
    }

    public void cancel() {
        this.thread.cancel();
    }

    protected void finalize() throws Throwable {
        this.thread.cancel();
        super.finalize();
    }

    public Timer() {
        this(false);
    }

    public Timer(boolean bl) {
        this.thread.setDaemon(bl);
    }

    private static class TimerThread
    extends Thread {
        private final Comparator TCOMP;
        private SortedSet tasks;
        private boolean canceled;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void schedule(TimerTask timerTask, Timer timer, long l, long l2, boolean bl) {
            if (this.canceled) {
                throw new IllegalStateException("timer has been canceled");
            }
            if (this.tasks.contains(timerTask)) {
                throw new IllegalStateException("task is already scheduled");
            }
            timerTask.timer = timer;
            timerTask.time = l;
            timerTask.period = l2;
            timerTask.fixedRate = bl;
            if (!this.isAlive()) {
                this.start();
            }
            this.tasks.add(timerTask);
            timerTask.changed = true;
            boolean bl2 = false;
            try {
                if (this.TCOMP.compare(timerTask, this.tasks.first()) >= 0) {
                    return;
                }
                boolean bl3 = true;
                bl2 = bl3;
            }
            catch (NoSuchElementException noSuchElementException) {
                bl2 = true;
            }
            if (!bl2) return;
            this.notify();
        }

        public synchronized boolean unschedule(TimerTask timerTask) {
            boolean bl = this.tasks.remove(timerTask);
            if (bl) {
                timerTask.timer = null;
                timerTask.changed = true;
            }
            return bl;
        }

        public synchronized void cancel() {
            Iterator iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                TimerTask timerTask = (TimerTask)iterator.next();
                timerTask.timer = null;
                timerTask.changed = true;
            }
            this.tasks.clear();
            this.canceled = true;
            this.notify();
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void run() {
            block9: while (true) {
                try {
                    var1_1 = ((TimerTask)this.tasks.first()).time - System.currentTimeMillis();
                    if (var1_1 <= 0L) {
                        var1_1 = -1L;
                    }
                }
                catch (NoSuchElementException var3_3) {
                    if (this.canceled) {
                        return;
                    }
                    var1_1 = 0L;
                }
                try {
                    this.wait(var1_1);
                }
                catch (IllegalArgumentException var3_4) {
                }
                catch (InterruptedException var3_5) {
                }
                while (true) {
                    try {
                        var3_2 = (TimerTask)this.tasks.first();
                    }
                    catch (NoSuchElementException var5_8) {
                        continue block9;
                    }
                    if (var3_2.time <= System.currentTimeMillis()) ** break;
                    continue block9;
                    var4_6 = var3_2.timer;
                    if (var3_2.period == -1L) {
                        this.tasks.remove(var3_2);
                        var3_2.timer = null;
                    }
                    var3_2.changed = false;
                    try {
                        var3_2.run();
                    }
                    catch (Throwable var5_9) {
                    }
                    if (var3_2.changed || var3_2.period == -1L) continue;
                    if (!var3_2.fixedRate) {
                        var3_2.time = System.currentTimeMillis();
                    }
                    var3_2.time += var3_2.period;
                    this.unschedule(var3_2);
                    this.schedule(var3_2, var4_6, var3_2.time, var3_2.period, var3_2.fixedRate);
                }
                break;
            }
        }

        TimerThread() {
            TimerThread timerThread = this;
            if (timerThread == null) {
                throw null;
            }
            this.TCOMP = new 1(timerThread);
            this.tasks = new TreeSet(this.TCOMP);
            this.canceled = false;
        }
    }
}

