/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1421746759512286392L;
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOADFACTOR = 0.75f;
    private HashMap map;
    private float loadFactor;

    public synchronized int size() {
        return this.map.size();
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized Enumeration keys() {
        return new Vector(this.map.keySet()).elements();
    }

    public synchronized Enumeration elements() {
        return new Vector(this.map.values()).elements();
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.map.containsValue(object);
    }

    public synchronized boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.map.containsKey(object);
    }

    public synchronized boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.map.containsValue(object);
    }

    public synchronized Object get(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return this.map.get(object);
    }

    protected synchronized void rehash() {
        this.map.rehash();
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        return this.map.put(object, object2);
    }

    public synchronized Object remove(Object object) {
        return this.map.remove(object);
    }

    public synchronized void putAll(Map map) {
        this.map.putAll(map);
    }

    public synchronized void clear() {
        this.map.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object clone() {
        try {
            Hashtable hashtable = (Hashtable)super.clone();
            hashtable.map = (HashMap)this.map.clone();
            return hashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public synchronized String toString() {
        return this.map.toString();
    }

    public synchronized Set keySet() {
        return this.map.keySet();
    }

    public synchronized Set entrySet() {
        return this.map.entrySet();
    }

    public synchronized Collection values() {
        return this.map.values();
    }

    public synchronized boolean equals(Object object) {
        return object instanceof Hashtable && this.map.equals(((Hashtable)object).map);
    }

    public synchronized int hashCode() {
        return this.map.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readInt();
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.map.put(object, object2);
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.map.table.length);
        objectOutputStream.writeInt(this.map.size());
        Iterator iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    /* synthetic */ HashMap access$0() {
        return this.map;
    }

    /* synthetic */ void access$1(HashMap hashMap) {
        this.map = hashMap;
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable(int n, float f) {
        this.map = new HashMap(n, f);
        this.loadFactor = f;
    }

    public Hashtable(Map map) {
        this.map = new HashMap(map);
    }

    private Hashtable(HashMap hashMap) {
        this.map = hashMap;
    }

    class DefaultSerialization {
        private float loadFactor;
        private int threshold;

        private void readDefaultObject() {
            Hashtable.this.access$1(new HashMap((int)((float)this.threshold / this.loadFactor), this.loadFactor));
        }

        private void writeDefaultObject() {
            this.loadFactor = Hashtable.this.access$0().loadFactor;
            this.threshold = (int)((float)Hashtable.this.access$0().table.length * this.loadFactor);
        }

        DefaultSerialization() {
        }
    }
}

