/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable,
Comparable {
    private static final long serialVersionUID = 7523967970034938905L;
    private long time = 0L;

    public static long UTC(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1900 + n, n2, n3, n4, n5, n6);
        return calendar.getTime().getTime();
    }

    public boolean after(Date date) {
        return this.getTime() > date.getTime();
    }

    public boolean before(Date date) {
        return this.getTime() < date.getTime();
    }

    public int compareTo(Object object) {
        return this.compareTo((Date)object);
    }

    public int compareTo(Date date) {
        long l;
        long l2 = this.getTime();
        return l2 == (l = date.getTime()) ? 0 : (l2 < l ? -1 : 1);
    }

    public boolean equals(Object object) {
        return object instanceof Date && this.getTime() == ((Date)object).getTime();
    }

    public int getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        return calendar.get(5);
    }

    public int getDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        return calendar.get(7) - 1;
    }

    public int getHours() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        return calendar.get(11);
    }

    public int getMinutes() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        return calendar.get(12);
    }

    public int getMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        return calendar.get(2);
    }

    public int getSeconds() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        return calendar.get(13);
    }

    public long getTime() {
        return this.time;
    }

    public int getTimezoneOffset() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        return calendar.get(15);
    }

    public int getYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        return calendar.get(1) - 1900;
    }

    public int hashCode() {
        return (int)this.getTime();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long parse(String string) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        try {
            return dateFormat.parse((String)string).time;
        }
        catch (ParseException parseException) {
            return 0;
        }
    }

    public void setDate(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        calendar.set(5, n);
        this.time = calendar.getTime().getTime();
    }

    private void setDay(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        calendar.set(7, n);
        this.time = calendar.getTime().getTime();
    }

    public void setHours(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        calendar.set(11, n);
        this.time = calendar.getTime().getTime();
    }

    public void setMinutes(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        calendar.set(12, n);
        this.time = calendar.getTime().getTime();
    }

    public void setMonth(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        calendar.set(2, n);
        this.time = calendar.getTime().getTime();
    }

    public void setSeconds(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        calendar.set(13, n);
        this.time = calendar.getTime().getTime();
    }

    public void setTime(long l) {
        this.time = l;
    }

    public void setYear(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this);
        calendar.set(1, 1900 + n);
        this.time = calendar.getTime().getTime();
    }

    public String toGMTString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss GMT");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(this);
    }

    public String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(this);
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        return simpleDateFormat.format(this);
    }

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(String string) {
        this.time = Date.parse(string);
    }

    public Date(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900 + n, n2, n3);
        this.time = calendar.getTime().getTime();
    }

    public Date(int n, int n2, int n3, int n4, int n5) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900 + n, n2, n3, n4, n5);
        this.time = calendar.getTime().getTime();
    }

    public Date(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1900 + n, n2, n3, n4, n5, n6);
        this.time = calendar.getTime().getTime();
    }

    public Date(long l) {
        this.time = l;
    }
}

