/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import kaffe.net.DefaultSocketImplFactory;

public class ServerSocket {
    private static SocketImplFactory factory = new DefaultSocketImplFactory();
    private SocketImpl impl;

    public Socket accept() throws IOException {
        Socket socket = new Socket();
        this.implAccept(socket);
        return socket;
    }

    protected final void implAccept(Socket socket) throws IOException {
        this.impl.accept(socket.impl);
        System.getSecurityManager().checkAccept(socket.getInetAddress().getHostName(), socket.getPort());
    }

    public void close() throws IOException {
        this.impl.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InetAddress getInetAddress() {
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException socketException) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                return InetAddress.getLoopback();
            }
        }
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public synchronized int getSoTimeout() throws IOException {
        return (Integer)this.impl.getOption(4102);
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }

    public static synchronized void setSocketFactory(SocketImplFactory socketImplFactory) throws IOException {
        factory = socketImplFactory;
    }

    public SocketImpl newSocketImpl() {
        return this.impl;
    }

    public String toString() {
        return this.impl.toString();
    }

    public ServerSocket(int n) throws IOException {
        this(n, 50);
    }

    public ServerSocket(int n, int n2) throws IOException {
        this(n, n2, null);
    }

    public ServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        System.getSecurityManager().checkListen(n);
        if (inetAddress == null) {
            inetAddress = InetAddress.getAnyAddress();
        }
        this.impl = factory.createSocketImpl();
        this.impl.create(true);
        this.impl.bind(inetAddress, n);
        this.impl.listen(n2);
    }
}

