/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Serializable;
import java.net.InetAddressImpl;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public final class InetAddress
implements Serializable {
    private static final long serialVersionUID = 3286316764910316507L;
    private static InetAddressImpl impl = new InetAddressImpl();
    private String hostName;
    private int address;
    private int family;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InetAddress)) {
            return false;
        }
        InetAddress inetAddress = (InetAddress)object;
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = this.getAddress();
        int n = byArray2.length;
        while (n-- > 0) {
            if (byArray2[n] == byArray[n]) continue;
            return false;
        }
        return this.getHostName().equals(inetAddress.getHostName());
    }

    public byte[] getAddress() {
        byte[] byArray = new byte[]{(byte)(this.address >> 24 & 0xFF), (byte)(this.address >> 16 & 0xFF), (byte)(this.address >> 8 & 0xFF), (byte)(this.address & 0xFF)};
        return byArray;
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        InetAddress[] inetAddressArray;
        if (string == null || string.equals("")) {
            throw new UnknownHostException(string == null ? "" : string);
        }
        if (Character.isDigit(string.charAt(0))) {
            inetAddressArray = new InetAddress[]{InetAddress.getByName(string)};
        } else {
            int[] nArray = impl.lookupAllHostAddr(string);
            int n = nArray.length;
            inetAddressArray = new InetAddress[n];
            int n2 = 0;
            while (n2 < n) {
                inetAddressArray[n2] = new InetAddress(string, nArray[n2]);
                ++n2;
            }
        }
        return inetAddressArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized InetAddress getByName(String string) throws UnknownHostException {
        int n;
        if (string == null) return InetAddress.getLoopback();
        if (string.equals("")) {
            return InetAddress.getLoopback();
        }
        if (!Character.isDigit(string.charAt(0))) {
            n = impl.lookupHostAddr(string);
            return new InetAddress(string, n);
        }
        n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            n <<= 8;
            try {
                n |= Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        string = null;
        return new InetAddress(string, n);
    }

    public String getHostAddress() {
        byte[] byArray = this.getAddress();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toString(byArray[0] & 0xFF));
        stringBuffer.append(".");
        stringBuffer.append(Integer.toString(byArray[1] & 0xFF));
        stringBuffer.append(".");
        stringBuffer.append(Integer.toString(byArray[2] & 0xFF));
        stringBuffer.append(".");
        stringBuffer.append(Integer.toString(byArray[3] & 0xFF));
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHostName() {
        try {
            if (this.hostName != null) return this.hostName;
            this.hostName = impl.getHostByAddr(this.address);
            return this.hostName;
        }
        catch (UnknownHostException unknownHostException) {
            this.hostName = this.getHostAddress();
        }
        return this.hostName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            String string = impl.getLocalHostName();
            System.getSecurityManager().checkConnect(string, 0);
            return InetAddress.getByName(string);
        }
        catch (SecurityException securityException) {
            return InetAddress.getLoopback();
        }
    }

    public int hashCode() {
        return this.address;
    }

    public boolean isMulticastAddress() {
        return (this.address & 0xE0000000) == -536870912;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHostName());
        stringBuffer.append("/");
        stringBuffer.append(this.getHostAddress());
        return stringBuffer.toString();
    }

    static InetAddress getLoopback() {
        return new InetAddress("loopback", 2130706433);
    }

    static InetAddress getAnyAddress() {
        InetAddress inetAddress = new InetAddress();
        impl.makeAnyLocalAddress(inetAddress);
        return inetAddress;
    }

    private InetAddress(String string, int n) {
        this.family = impl.getInetFamily();
        this.hostName = string;
        this.address = n;
    }

    InetAddress() {
    }
}

