/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import kaffe.io.ByteToCharConverter;

public class InputStreamReader
extends Reader {
    private static final int BUFDEFAULT = 128;
    private ByteToCharConverter encoding;
    private InputStream strm;
    private byte[] inbuf = new byte[128];

    public void close() throws IOException {
        if (this.strm != null) {
            this.strm.close();
        }
    }

    public String getEncoding() {
        return this.encoding.toString();
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        Object object = this.lock;
        synchronized (object) {
            n3 = this.encoding.flush(cArray, n, n2);
            while (n2 > n3) {
                int n4;
                int n5 = n2 - n3;
                if (n5 > this.inbuf.length) {
                    n5 = this.inbuf.length;
                }
                if ((n4 = this.strm.read(this.inbuf, 0, n5)) < 0) break;
                n3 += this.encoding.convert(this.inbuf, 0, n4, cArray, n + n3, n2 - n3);
                if (n4 < n5) break;
            }
            if (n3 <= 0) {
                int n6 = -1;
                Object var7_10 = null;
                return n6;
            }
            int n7 = n3;
            Object var7_11 = null;
            return n7;
        }
    }

    public boolean ready() throws IOException {
        return this.strm.available() > 0;
    }

    public InputStreamReader(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.strm = inputStream;
        this.encoding = ByteToCharConverter.getDefault();
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.strm = inputStream;
        this.encoding = ByteToCharConverter.getConverter(string);
    }
}

