//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “ViewBase.cpp”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	Place-Holder until I develop a better structured interface
	between the drawing routines and the drawing modules.
*/
//====//====//====//====//====//====//====//====//====//====//

	#include <Rect.h>

	class BView;
	class nnode;
	class Buff;

	class ViewBase{
		public:
			ViewBase();
			~ViewBase();

			void Target(BView *vv,float fh,float ffh,float width,Buff *cb);

			void Draw(BRect dest,float tlx,float tly);
			void Locate2(int32 &x,int32 &y,int place);
			void Locate(float &x,float &y,int place);
			float LocateY(int place);
			int Place(float x,float y);

			int vmode;
			struct colscheme *csh;
		private:

			void DrawTxt(BRect dest,float tlx,float tly);
			float LocTxtY(int place);
			void LocTxt(float &x,float &y,int place);
			void LocTxt2(int32 &x,int32 &y,int place);

			void DrawHex(BRect dest,float tlx,float tly);
			float LocHexY(int place);
			void LocHex(float &x,float &y,int place);

			void DrawHTML(BRect dest,float tlx,float tly);

			void SHC(const struct rgb_color &n);


			int MassageTxt(char *s,int l,char *dst);

			Buff *cb;
			BView *vv;
			float fh,ffh,width;
			nnode *nt;
	};
