//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “SMap.h”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	Poor place holder for cached drawing information.
	Expect this class to be removed in future.
*/
//====//====//====//====//====//====//====//====//====//====//

#ifndef SMAP_H
	#define SMAP_H

	#include <Bitmap.h>

	#define MAX_REG 16

	class SMap : public BBitmap{

		public:
						SMap(color_space space,long xx, long yy);
			virtual     ~SMap();
			float       origx,origy,bigx,bigy;

//            void        GetCXY(int cnum,float &x,float &y);
			void        AssertStats(class Buff *,class BFont *,int32 style,struct colscheme *);
			BRect       FixDamage(BRect src);
			color_space uspace;

			BRect validrect;
			int32       When(){return when;};
			int32       life,when;

			BView       *bmv;

		private:
			void       ReDrawLine(char *txt,int sx2,float scrx,float scry);
			void       ReDrawLin(char *txt,float scrx,float scry);
			void        Mark(BRegion *reg,int curs);

			int32       sstyle;

			BRect       cdrw;
			float       fh,ffh,spcw,szex;
			BFont       myfont;
			Buff        *cb;

			BRegion     rg[MAX_REG];
			int32           rcod[MAX_REG];
			rgb_color   rcode[MAX_REG];
			int32           creg;
			int32           mod;
			char            *dat;

			void        Inserter(BRegion *in,int32 fr,int32 cc);
			void        MySetCol(rgb_color col);
			int32       fillcol[2];
			void        MyFillRect(BRect rect);
			void        MyFillRegion(BRegion *reg);

			class CList       *overlist,*copylist,*freelist;

			float QueueString(char *,int32,float,float,rgb_color);
			void FlushDrwQueue(CList *,int32 type);

			rgb_color ColForState(int32 state);

			struct colscheme *myscheme;

			void MyLowColor(rgb_color);
			rgb_color   llc;
	};

#endif //SMAP_H
