//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “BufList.h”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	A list of buffer Names for the 'Doc List' Menu.
	Organised this way to prevent deadlocks.
*/
//====//====//====//====//====//====//====//====//====//====//

#ifndef BUFLIST_H
	#define BUFLIST_H
	#include <Locker.h>

	class BList;
	class Buff;
	class YateWindow;

	class BufList:public BLocker{
		public:
			BufList();
			virtual ~BufList();

			Buff *BuffAt(int32 index);
			char *NameAt(int32 index);
			int32 Count(){return cnt;}

			void SetBuff(int32 index,Buff *);
			void SetName(int32 index,const char*);
			void SetCount(int32 c){cnt=c;}
		private:
			CList *bf,*nl;
			int32 cnt;

	};

	extern BufList *gb; //Global Buffer List
#endif //BUFLIST_H
