//====//====//====//====//====//====//====//====//====//====//
/*
	Project: YATE (Yet Another Text Editor)
	File: “BSBar.cpp”

	Copyright © 1996-1998 Acid Software, All Rights Reserved.

	BSBar - a remembering BScrollBar with a ValueChanged() port
*/
//====//====//====//====//====//====//====//====//====//====//

#include <stdio.h>

#include "cb_list.h"
#include "BSBar.h"
#include "BMapView.h"

BSBar::BSBar(BRect frame, const char *name,port_id drawport, long min, long max, orientation posture)
	:BScrollBar(frame,name,NULL,min,max,posture)
{
	lastindex=NULL;
	bflist=new CList();
	valist=new CList();
	drprt=drawport;
}

BSBar::~BSBar(){
	delete bflist;
	delete valist;
}

void BSBar::Capture(float mult){
	long    tt;

	if (lastindex){
		tt=bflist->IndexOf(lastindex);
		if (tt<0){
			printf("error in BSBar->ChangeBuff()\n");
		}else{
			valist->SwapWithF(Value()/mult,tt);
		}
	}
}

void BSBar::ChangeIndex(float mult,void *newindex,float def){
	long    tt;

	tt=bflist->IndexOf(newindex);
	lastindex=newindex;
	if (tt<0){
		bflist->Add(lastindex);
		valist->AddF(def);
		SetValue(def);
	}else{
		SetValue(valist->ItemF(tt)*mult);
	}
}

void BSBar::ValueChanged(float vv){
	if (lastv!=vv){
		write_port(drprt,SCROLLBAR_MOVE,NULL,0);
		lastv=vv;
	}
}
