#include "memory"
#include "intGadg.h"
#include "myButtonGadgA.h"
#include "warning.h"
#include "colorWellGadg.h"
#include "textItem.h"
#include "layoutMatrixItem.h"

//dtor
LayoutMatrixItem	::	~LayoutMatrixItem()
{
//left blank
}


//ctor
LayoutMatrixItem	::	LayoutMatrixItem(	BWindow * paramWindow, 
											void * paramItem, 
											BList * pparamMatrixItemList,
											const uint32 paramKind) 
					: 	window(paramWindow), 
						item(paramItem), 
						kind(paramKind) 
{
	pparamMatrixItemList->AddItem(this);
}//end


//calculates the minimum appropriate width and height
//of a matrix item (currently only MyButtonGadgs & IntGadgets)
void 
LayoutMatrixItem	::	Calc(	const BFont *	paramFont) 
{
	const float pad = 13;
	//use pad to give a bit of room at each end of the
	//button to set off the button text
	BRect br(0, 0, 10, 10);
	BView view(br, "LayoutMatrixItem temp view", B_FOLLOW_NONE, B_WILL_DRAW);
	//need to attach these items to a BView before they
	//can be measured
	window->Lock();
	window->AddChild(&view);
	if (paramFont) 
	{
		view.SetFont(paramFont);
	}
	//set the view's font so the buttons will inherit them
	//when size is checked
	switch (kind) 
	{
		case KIND_BBUTTON: 
		{
			view.AddChild((BButton *)item);
			float labelWidth = pad + view.StringWidth(((BButton *)item)->Label());
			((BButton *)item)->GetPreferredSize(&widthPref, &heightPref);
			//PreferredSize uses a huge pad--I dislike the wasted space
			//so I compute labelWidth plus some small padding...
			if (labelWidth > widthPref) 
			{
				widthPref = labelWidth;
			}
			else 
			{
				labelWidth = widthPref;
			}
			//then use the smaller width--might be good to perform
			//the same opperation for height, though the preferred 
			//height seems OK
			((BButton *)item)->ResizeTo(labelWidth, heightPref);
			view.RemoveChild((BButton *)item);
		break;
		}
		case KIND_INTGADG: 
		{
			view.AddChild((IntGadg *)item);
			float labelWidth = pad + view.StringWidth(((IntGadg *)item)->Label());
			((IntGadg *)item)->GetPreferredSize(&widthPref, &heightPref);
			((IntGadg *)item)->SetDivider(labelWidth);
			float inputWidth = view.StringWidth("0404040404");
			widthPref = labelWidth + inputWidth;
			((IntGadg *)item)->ResizeTo(widthPref, heightPref);
			view.RemoveChild((IntGadg *)item);
		break;
		}
		case KIND_TEXT: 
		{
			widthPref = pad + view.StringWidth(((TextItem *)item)->text);
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			heightPref = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
		break;
		}
		case KIND_COLORWELLGADG: 
		{
			widthPref = pad + view.StringWidth((((ColorWellGadg *)item)->GetTextItem())->text) + COLORWELLWIDTH;
			((ColorWellGadg *)item)->SetLeft(widthPref - COLORWELLWIDTH - pad);//store this temp value until time to really place item
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			float totalHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
			((ColorWellGadg *)item)->descender = (fontHeight.ascent - fontHeight.descent) / 2;
			if (COLORWELLHEIGHT > totalHeight)
			{
				heightPref = COLORWELLHEIGHT;
			}
			else
			{
				heightPref = totalHeight;
			}
			((ColorWellGadg *)item)->SetTop(heightPref);//store this temp value until time to really place item
			float framing = ((ColorWellGadg *)item)->Frame().Width();
			int32 int32Framing = ((ColorWellGadg *)item)->Frame().IntegerWidth();
			if (framing > heightPref)
			{
				if (!(int32Framing % 2))
				{
					framing--;
				}
				((ColorWellGadg *)item)->ResizeTo(framing, framing);
			}
			else
			{
				int32 int32HeightPref = heightPref;
				if (!(int32HeightPref % 2))
				{
					heightPref--;
				}
				((ColorWellGadg *)item)->ResizeTo(heightPref, heightPref);
			}
		break;
		}
		case KIND_MYBUTTON:
		{
			widthPref = pad + view.StringWidth((((MyButtonGadgA *)item)->GetTextItem())->text);
			((MyButtonGadgA *)item)->SetLeft(widthPref- pad);//store this temp value until time to really place item
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			float totalHeight = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
			((MyButtonGadgA *)item)->SetTop(totalHeight);//store this temp value until time to really place item
			if (totalHeight > heightPref)
			{
				heightPref = totalHeight;
			}
		break;
		}
	}
	window->RemoveChild(&view);
	window->Unlock();
}//end