#include "memory"
#include "intGadg.h"
#include "myButtonGadgA.h"
#include "warning.h"
#include "colorWellGadg.h"
#include "textItem.h"
#include "layoutMatrix.h"
#include "layoutMatrixItem.h"


//ctor--just initialize
LayoutMatrix	::	LayoutMatrix(	BWindow * pparamWindow, 
									const uint32 ui32paramFlags, 
									const uint32 ui32paramRows, 
									const uint32 ui32paramColumns) 
				: 	itemsList(new BList()), 
					mpChildrenToAdd(new BList()), 
					mpItemsToDraw(new BList()), 
					window(pparamWindow), 
					rows(ui32paramRows), 
					columns(ui32paramColumns), 
					flags(ui32paramFlags), 
					bottom(0) 
{
//left blank
}//end


//dtor
LayoutMatrix	::	~LayoutMatrix() 
{
//may have a memory leak here--especially with TextItems
	delete mpChildrenToAdd;
	delete mpItemsToDraw;
}//end


//calculate the view positions of all the MatrixLayoutItems
//on the items list with offsets based upon matrixLeft
//and matrixTop
void 
LayoutMatrix	::	Calc(	const float fparamMatrixLeft, 
							bool bparamAllowForMenu,
							sem_id paramSemID) 
{
	if (acquire_sem(paramSemID) != B_NO_ERROR)
	{
		warning("Aquire_sem failed\n");
		return;
	}
	const float hpad = 2;	//horizontal spacing between items
	const float vpad = 2;	//vertical spacing between items
	float localLeft = fparamMatrixLeft + hpad;
	float mb_height = 0;
	if (bparamAllowForMenu)
	{
		try
		{
			auto_ptr<BMenuBar> apBMenuBar(new BMenuBar(BRect(0, 0, 1000, 15), "Ty"));
			BMenuBar * pholdBMenuBar = apBMenuBar.get();
			mb_height = pholdBMenuBar->Bounds().Height();
		}
		catch(...)
		{
			warning("New failed\n");
			mb_height = 20;
		}
	}
	float localTop = mb_height + vpad;
	float preTop = 0;
	uint32 index = 0;
	TextItem *	scratchTextItem;
	BView view(BRect(0, 0, 10, 10), "LayoutMatrixView", B_FOLLOW_NONE, B_WILL_DRAW);
	//need to attach these items to a BView before they
	//can be Resize()ed and MoveTo()ed
	window->Lock();
	window->AddChild(&view);
	float widest = 0;
	float tallest = 0;
	if (flags & SAMESIZE) 
	{
	//SAMESIZE makes all items the same size as the largest
		//find the tallest and widest item:
		for (uint32 i = 0; i < rows; i++) 
		{
			for (uint32 j = 0; j < columns; j++) 
			{
				LayoutMatrixItem * lmi = (LayoutMatrixItem *)itemsList->ItemAt(index++);
				switch (lmi->kind) 
				{
					case KIND_BBUTTON:
					case KIND_INTGADG:
						if (lmi->widthPref > widest) 
						{
							widest = lmi->widthPref;
						}
						if (lmi->heightPref > tallest) 
						{
							tallest = lmi->heightPref;
						}
					break;
//					case KIND_TEXT: //nothing needed from this
					case KIND_COLORWELLGADG: 
						if (((ColorWellGadg *)lmi->item)->Frame().Height() > tallest) 
						{
							tallest = ((ColorWellGadg *)lmi->item)->Frame().Height();
						}
					break;
				}
			}
		}
		index = 0;
		//Resize all items to match largest:
		for (uint32 i = 0; i < rows; i++) 
		{
			for (uint32 j = 0; j < columns; j++) 
			{
				LayoutMatrixItem * lmi = (LayoutMatrixItem *)itemsList->ItemAt(index++);
				switch (lmi->kind)
				{
					case KIND_BBUTTON:
					{
						BButton * scratchMyButtonGadg = (BButton *)lmi->item;
						view.AddChild(scratchMyButtonGadg);
						scratchMyButtonGadg->ResizeTo(widest, tallest);
						view.RemoveChild(scratchMyButtonGadg);
					break;
					}
					case KIND_INTGADG:
					{
						IntGadg * scratchIntGadg = (IntGadg *)lmi->item;
						view.AddChild(scratchIntGadg);
						scratchIntGadg->ResizeTo(widest, tallest);
						view.RemoveChild(scratchIntGadg);
					break;
					}
//					case KIND_TEXT: //nothing needed from this
//					case KIND_COLORWELLGADG: //nothing needed from this
				}
			}
		}
	}
	else if (flags & BESTSIZE) 
	{
	//BESTSIZE leaves all item widths at minimum--might be best 
	//to also leave height, as it is they are always the
	//preffered height based upon the buttons' font
		//find tallest item:
		for (uint32 i = 0; i < rows; i++) 
		{
			for (uint32 j = 0; j < columns; j++) 
			{
				LayoutMatrixItem * lmi = (LayoutMatrixItem *)itemsList->ItemAt(index++);
				switch (lmi->kind) 
				{
					case KIND_BBUTTON:
					case KIND_INTGADG:
					case KIND_TEXT:
						if (lmi->heightPref > tallest) 
						{
							tallest = lmi->heightPref;
						}
					break;
					case KIND_COLORWELLGADG:
						if (lmi->heightPref > COLORWELLHEIGHT)
						{
							if (lmi->heightPref > tallest) 
							{
								tallest = lmi->heightPref;
							}
						}
						else
						{
							if (((ColorWellGadg *)lmi->item)->Frame().Height() > tallest) 
							{
								tallest = ((ColorWellGadg *)lmi->item)->Frame().Height();
							}
						}
					break;
				}
			}
		}
		index = 0;
		//Resize all items to match largest height:
		for (uint32 i = 0; i < rows; i++) 
		{
			for (uint32 j = 0; j < columns; j++) 
			{
				LayoutMatrixItem * lmi = (LayoutMatrixItem *)itemsList->ItemAt(index++);
				switch (lmi->kind) 
				{
					case KIND_BBUTTON:
					{
						BButton * scratchMyButtonGadg = (BButton *)lmi->item;
						view.AddChild(scratchMyButtonGadg);
						scratchMyButtonGadg->ResizeTo(lmi->widthPref, tallest);
						view.RemoveChild(scratchMyButtonGadg);
					break;
					}
					case KIND_INTGADG:
					{
						IntGadg * scratchIntGadg = (IntGadg *)lmi->item;
						view.AddChild(scratchIntGadg);
						scratchIntGadg->ResizeTo(lmi->widthPref, tallest);
						view.RemoveChild(scratchIntGadg);
					break;
					}
//					case KIND_TEXT: //nothing needed from this
//					case KIND_COLORWELLGADG: //nothing needed from this
				}
			}
		}
	}
	index = 0;
	//move every item based upon size and padding:
	float excessRight, excessBottom;
	for (uint32 i = 0; i < rows; i++) 
	{
		localLeft = fparamMatrixLeft + hpad;
		for (uint32 j = 0; j < columns; j++) 
		{
			LayoutMatrixItem * lmi = (LayoutMatrixItem *)itemsList->ItemAt(index++);
			switch (lmi->kind) 
			{
				case KIND_BBUTTON:
				{
					BButton * scratchMyButtonGadg = (BButton *)lmi->item;
					view.AddChild(scratchMyButtonGadg);
					scratchMyButtonGadg->MoveTo(localLeft, localTop);
					view.RemoveChild(scratchMyButtonGadg);
					excessRight = hpad + scratchMyButtonGadg->Bounds().Width();
				break;
				}
				case KIND_INTGADG:
				{
					IntGadg * scratchIntGadg = (IntGadg *)lmi->item;
					view.AddChild(scratchIntGadg);
					scratchIntGadg->MoveTo(localLeft, localTop);
					view.RemoveChild(scratchIntGadg);
					excessRight = hpad + scratchIntGadg->Bounds().Width();
				break;
				}
				case KIND_TEXT:
					scratchTextItem = (TextItem *)lmi->item;
					scratchTextItem->left = localLeft;
					scratchTextItem->top = localTop + lmi->heightPref;
					excessRight = hpad + lmi->widthPref;
				break;
				case KIND_COLORWELLGADG:
					scratchTextItem = ((ColorWellGadg *)lmi->item)->GetTextItem();
					scratchTextItem->left = localLeft;
					((ColorWellGadg *)lmi->item)->SetLeft(((ColorWellGadg *)lmi->item)->GetLeft() + localLeft);
					scratchTextItem->top = localTop + lmi->heightPref;
					((ColorWellGadg *)lmi->item)->SetTop(((ColorWellGadg *)(lmi->item))->descender + (scratchTextItem->top - ((((ColorWellGadg *)lmi->item)->GetTop()) / 2)) - (lmi->heightPref / 2));
					excessRight = hpad + lmi->widthPref;
				break;
			}
			localLeft += excessRight;
			if (columns - 1) 
			{
				if (j != (columns - 1)) 
				{
					if (localLeft > right) 
					{
						right = localLeft;
					}
				}
				else 
				{
					right = localLeft;
				}
			}
			else 
			{
				if (localLeft > right) 
				{
					right = localLeft;
				}
			}
			//right is stored so that another MatrixLayout
			//can know where a previous one ended up
			switch (lmi->kind) 
			{
				case KIND_BBUTTON:
				{
					BButton * scratchMyButtonGadg = (BButton *)lmi->item;
					if (preTop < scratchMyButtonGadg->Bounds().Height()) 
					{
						preTop = scratchMyButtonGadg->Bounds().Height();
					}
				break;
				}
				case KIND_INTGADG:
				{
					IntGadg * scratchIntGadg = (IntGadg *)lmi->item;
					if (preTop < scratchIntGadg->Bounds().Height()) 
					{
						preTop = scratchIntGadg->Bounds().Height();
					}
				break;
				}
				case KIND_TEXT:
					if (preTop < lmi->heightPref) 
					{
						preTop = lmi->heightPref;
					}
				case KIND_COLORWELLGADG:
					if (lmi->heightPref > COLORWELLHEIGHT)
					{
						if (preTop < (lmi->heightPref + ((ColorWellGadg *)(lmi->item))->descender))
						{
							preTop = lmi->heightPref + ((ColorWellGadg *)(lmi->item))->descender;
						}
					}
					else
					{
						if (preTop < COLORWELLHEIGHT) 
						{
							preTop = COLORWELLHEIGHT;
						}
					}
				break;
			}
		}
		excessBottom = vpad + preTop;
		localTop += excessBottom;
		if (rows - 1) 
		{
			if (i != (rows - 1)) 
			{
				if (localTop > bottom) 
				{
					bottom = localTop;
				}
				else 
				{
					bottom = localTop;
				}
			}
			else 
			{
				bottom = localTop;
			}
		}
		else 
		{
			if (localTop > bottom) 
			{
				bottom = localTop;
			}
		}
		//bottom is stored so that another MatrixLayout
		//can know where a previous one ended up
	}
	window->RemoveChild(&view);
	window->Unlock();
	release_sem(paramSemID);
}//end


void
LayoutMatrix	::	AddToChildren(	void * item) 
{
	mpChildrenToAdd->AddItem(item);
}//end


void
LayoutMatrix	::	AddToDraw(	void * item) 
{
	mpItemsToDraw->AddItem(item);
}//end