#!/bin/sh

THIS_DIR=$(dirname $0)
DATA_DIR=${THIS_DIR}

THIS_DIR=$(${DATA_DIR}/ResolvePath ${THIS_DIR} )
DATA_DIR=$(${DATA_DIR}/ResolvePath ${DATA_DIR} )

PAR_DIR=$(dirname ${THIS_DIR})
PAR_DIR=$(${DATA_DIR}/ResolvePath ${PAR_DIR} )

test "${PWD}" "!=" "$(${DATA_DIR}/FindDir home)" && {
	ALT_DIR1=${PWD}
}
test "${PAR_DIR}" "!=" "${PWD}" && {
	ALT_DIR2=${PAR_DIR}
}

mimeset -F ${DATA_DIR}

echo "Really install?"
alert --info "Running this script will install the TraX application onto your hard drive.
Do you want to do this?" "No" "Yes" && {
	echo "Install terminated"
	exit 1
}

OK=0

while [ ${OK} -ne 2 ]
do
	WHERE=$(${DATA_DIR}/SelectFolder "Where should Trax be installed?" $(${DATA_DIR}/FindDir apps C:bin home) ${ALT_DIR1} ${ALT_DIR2} )

	echo "Install into ${WHERE}?"
	alert --info "Installing into
${WHERE}/TraX/
Okay?" "Cancel" "No" "Yes";  OK=$?

	test ${OK} -eq 0 && 	{
		echo "Install terminated"
		exit 1
	}
	
done

cd ${WHERE}

${DATA_DIR}/WaitBar --start &
${DATA_DIR}/WaitBar "Installing..."

echo "Installing main files..."
unzip -o ${DATA_DIR}/Data.zip $(cat ${DATA_DIR}/Regular.Files)

${DATA_DIR}/WaitBar --hide

echo "Install Source?"
alert --info "Install source code?" "Yes" "No" && {
	${DATA_DIR}/WaitBar "Installing source..."
	echo "Installing source code..."
	unzip -o ${DATA_DIR}/Data.zip $(cat ${DATA_DIR}/Source.Files)
	${DATA_DIR}/WaitBar --hide
}

${DATA_DIR}/WaitBar --stop

TRAX_BIN=$(${DATA_DIR}/ResolvePath ${WHERE}/TraX/bin/)

DESKBAR=$(${DATA_DIR}/FindDir "deskbar")

test -w "${DESKBAR}/Applications/" && {
	echo "Add to Deskbar?"
	alert --idea "Add link on Deskbar (Be Menu)?" "No" "Yes" ||	{

		LINK_TO="${DESKBAR}/Applications"

		echo "Linking ${TRAX_BIN}/TraX to ${LINK_TO}"
		ln -s ${TRAX_BIN}/TraX ${LINK_TO}

		echo "Linking ${TRAX_BIN}/FastTraX to ${LINK_TO}"
		ln -s ${TRAX_BIN}/FastTraX ${LINK_TO}
	}
}

DESKTOP=$(${DATA_DIR}/FindDir "desktop")

test -w ${DESKTOP} && {
	echo "Add to Desktop?"
	alert --idea "Add link on Desktop?" "No" "Yes" ||	{

		LINK_TO="${DESKTOP}"

		echo "Linking ${TRAX_BIN}/TraX to ${LINK_TO}"
		ln -s ${TRAX_BIN}/TraX ${LINK_TO}

		echo "Linking ${TRAX_BIN}/FastTraX to ${LINK_TO}"
		ln -s ${TRAX_BIN}/FastTraX ${LINK_TO}
	}
}

test -w ${DATA_DIR} &&	{
	echo "Delete Install files?"
	alert --warning "Delete Install Files?" "No" "Yes" || {
		echo "Deleting install files..."
		rm -rv ${DATA_DIR}
	}
}

