/****************************************************************************
** 	CrypticWindow.h
**
**	Copyright (C) 2000, Jason Parks <atreyu@acm.org>.  All rights reserved.
**
*****************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _CRYPTIC_WINDOW_H
#define _CRYPTIC_WINDOW_H

#include <Window.h>

const int32 BLOWFISH	= 'bfsh';
const int32 ENCRYPT		= 'encr';
const int32 DECRYPT		= 'decr';
const int32 SET_ENCRYPT	= 'senc';
const int32 SET_DECRYPT	= 'sdec';
const int32 KEY			= 'key ';
const int32 RETYPE		= 'rety';
const int32 CANCEL		= 'canl';
const int32 OK			= 'okay';

const uint32 BLOWFISH_ENCRYPT 	= 'blow';
const uint32 BLOWFISH_DECRYPT 	= 'fish';

class CrypticWindow : public BWindow
{
	public:
		CrypticWindow(BRect frame, entry_ref dir_ref, BMessage *msg);
	
		void MessageReceived(BMessage *msg);
			 		
	private:
		bool encrypt;
		int32 encryptionType;
		
		entry_ref dir_ref; 
		BMessage *message;
		
		BTextControl *keyField;
		BTextControl *retypeField;
		
		uint32 ComputeOutType();
};

#endif