#include "NodeMonitorHelpers.h"
#include "PathMonitor.h"

#include <Application.h>
#include <stdio.h>

int main() {
	new BApplication("application/x-vnd.sve-test");
	new BWindow(BRect(10,10,20,20), "hi", (window_type)0, 0,0);


	printf("Monitoring /boot/home, the Trash can, and NetPositive's settings for the next ten minutes.\n");
	printf("Subsequent output is debug output from the library.\n");
	
	BDirectory dir("/boot/home/");
	new DirectoryMonitor(dir);	

	dir.SetTo("/boot/home/Desktop/Trash/");
	new DirectoryMonitor(dir);	

	BNode file("/boot/home/config/settings/NetPositive/settings");
	new NodeMonitor(file);	

	BEntry file2("/boot/home/.bash_history");
	new PathMonitor(file2);
		
	snooze(600*1000*1000);
	printf("Done monitoring.\n");
}